/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.SuccessResult;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.AccessibilityUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import org.jetbrains.annotations.NotNull;

public class VideoPreviewView
extends RelativeLayout {
    private static final int PLAY_BUTTON_DIAMETER_DP = 48;
    private static final int PLAY_ARROW_OFFSET_DP = 3;
    private final ImageView thumbnailImageView;
    private final ImageView playButton;
    private final ProgressBar loadingSpinner;

    public VideoPreviewView(@NonNull Context context, Provider<AppConfig> appConfigProvider, StyleType style) {
        super(context);
        BlockUtils.createLayoutParams((View)this, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)this);
        this.thumbnailImageView = this.getVideoImageView(context);
        this.playButton = this.getPlayButtonView(context);
        this.loadingSpinner = this.getLoadingSpinner();
        this.addView((View)this.thumbnailImageView);
        this.addView((View)this.playButton);
        this.addView((View)this.loadingSpinner);
        int color2 = appConfigProvider.get().getPrimaryColor();
        if (style == StyleType.POST) {
            color2 = ColorUtils.lightenColor(color2);
        }
        if (ColorUtils.isColorLight(color2)) {
            int blackColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_accessibility_black);
            this.playButton.setColorFilter(blackColor, PorterDuff.Mode.SRC_ATOP);
        } else {
            this.playButton.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        }
        AccessibilityUtils.INSTANCE.removeClickAbilityAnnouncement((View)this);
        AccessibilityUtils.INSTANCE.addClickAbilityAnnouncement((View)this.playButton);
    }

    public ImageView getThumbnailImageView() {
        return this.thumbnailImageView;
    }

    public void displayThumbnail(String thumbnailUrl) {
        this.loadingSpinner.setVisibility(0);
        this.thumbnailImageView.setVisibility(4);
        ImageRequest imageRequest = new ImageRequest.Builder(this.getContext()).data((Object)thumbnailUrl).placeholder(R.drawable.intercom_video_thumbnail_fallback).error(R.drawable.intercom_video_thumbnail_fallback).crossfade(true).target(this.thumbnailImageView).listener(new ImageRequest.Listener(){

            public void onStart(@NotNull ImageRequest imageRequest) {
            }

            public void onCancel(@NotNull ImageRequest imageRequest) {
            }

            public void onError(@NonNull ImageRequest imageRequest, @NonNull ErrorResult errorResult) {
                VideoPreviewView.this.loadingSpinner.setVisibility(8);
                VideoPreviewView.this.thumbnailImageView.setVisibility(0);
                VideoPreviewView.this.updateThumbnailAspectRatio();
                VideoPreviewView.this.playButton.setVisibility(8);
            }

            public void onSuccess(@NonNull ImageRequest imageRequest, @NonNull SuccessResult successResult) {
                VideoPreviewView.this.loadingSpinner.setVisibility(8);
                VideoPreviewView.this.thumbnailImageView.setVisibility(0);
                VideoPreviewView.this.updateThumbnailAspectRatio();
                int colour = ContextCompat.getColor((Context)VideoPreviewView.this.thumbnailImageView.getContext(), (int)R.color.intercom_semi_transparent);
                VideoPreviewView.this.thumbnailImageView.setColorFilter(colour, PorterDuff.Mode.DARKEN);
                VideoPreviewView.this.playButton.setVisibility(0);
            }
        }).build();
        IntercomCoilKt.loadIntercomImage(this.getContext(), imageRequest);
    }

    private void updateThumbnailAspectRatio() {
        this.thumbnailImageView.getLayoutParams().height = this.thumbnailImageView.getWidth() * 3 / 4;
    }

    public void showFailedImage() {
        this.thumbnailImageView.post(() -> BackgroundUtils.setBackground((View)this.thumbnailImageView, ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.intercom_video_thumbnail_fallback)));
    }

    private ImageView getPlayButtonView(Context context) {
        int diameterPx = ScreenUtils.dpToPx(48.0f, context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(diameterPx, diameterPx);
        params.addRule(13);
        ImageView playButton = new ImageView(context);
        playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        playButton.setScaleType(ImageView.ScaleType.CENTER);
        playButton.setImageResource(R.drawable.intercom_play_arrow);
        playButton.setPadding(ScreenUtils.dpToPx(3.0f, context), 0, 0, 0);
        playButton.setBackgroundResource(R.drawable.intercom_solid_circle);
        playButton.setVisibility(8);
        playButton.setId(R.id.intercom_video_thumbnail_play_button);
        AccessibilityUtils.INSTANCE.addClickAbilityAnnouncement((View)playButton);
        return playButton;
    }

    private ImageView getVideoImageView(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        ImageView videoImage = new ImageView(context);
        videoImage.setLayoutParams((ViewGroup.LayoutParams)params);
        videoImage.setAdjustViewBounds(true);
        videoImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        videoImage.setId(R.id.intercom_video_thumbnail);
        return videoImage;
    }

    private ProgressBar getLoadingSpinner() {
        View view = VideoPreviewView.inflate((Context)this.getContext(), (int)R.layout.intercom_progress_bar, null);
        return (ProgressBar)view.findViewById(R.id.progressBar);
    }
}

