/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Author;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.Image;
import java.util.HashMap;
import java.util.Map;

public class Link
implements Parcelable {
    private final BlockType type;
    private final String text;
    private final String title;
    private final String description;
    private final String linkType;
    private final Author author;
    private final Image image;
    private final Map<String, String> data;
    private final String siteName;
    private final String articleId;
    private final String url;
    public static final Parcelable.Creator<Link> CREATOR = new Parcelable.Creator<Link>(){

        public Link createFromParcel(Parcel in) {
            return new Link(in);
        }

        public Link[] newArray(int size) {
            return new Link[size];
        }
    };

    Link() {
        this(new Builder());
    }

    public static Link fromBlock(Block block) {
        if (block == null) {
            return new Link();
        }
        Builder builder = new Builder();
        builder.type = block.getType().name();
        builder.text = block.getText();
        builder.title = block.getTitle();
        builder.description = block.getDescription();
        builder.linkType = block.getLinkType();
        builder.author = block.getAuthor();
        builder.image = block.getImage();
        builder.data = block.getData();
        builder.siteName = block.getSiteName();
        builder.articleId = block.getArticleId();
        builder.url = block.getUrl();
        return new Link(builder);
    }

    private Link(Builder builder) {
        this.type = BlockType.typeValueOf(builder.type);
        this.text = builder.text == null ? "" : builder.text;
        this.title = builder.title == null ? "" : builder.title;
        this.description = builder.description == null ? "" : builder.description;
        this.linkType = builder.linkType == null ? "" : builder.linkType;
        this.siteName = builder.siteName == null ? "" : builder.siteName;
        this.articleId = builder.articleId == null ? "" : builder.articleId;
        this.author = builder.author == null ? new Author() : builder.author;
        this.image = builder.image == null ? new Image() : builder.image;
        this.data = builder.data == null ? new HashMap() : builder.data;
        this.url = builder.url == null ? "" : builder.url;
    }

    public BlockType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getArticleId() {
        return this.articleId;
    }

    public String getUrl() {
        return this.url;
    }

    public Author getAuthor() {
        return this.author;
    }

    public Image getImage() {
        return this.image;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String toString() {
        return "LinkCard{type=" + (Object)((Object)this.type) + ", text='" + this.text + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", linkType='" + this.linkType + '\'' + ", author=" + this.author + ", image=" + this.image + ", data=" + this.data + ", siteName='" + this.siteName + '\'' + ", articleId='" + this.articleId + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link linkBlock = (Link)o;
        if (this.type != linkBlock.type) {
            return false;
        }
        if (this.text != null ? !this.text.equals(linkBlock.text) : linkBlock.text != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(linkBlock.title) : linkBlock.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(linkBlock.description) : linkBlock.description != null) {
            return false;
        }
        if (this.linkType != null ? !this.linkType.equals(linkBlock.linkType) : linkBlock.linkType != null) {
            return false;
        }
        if (this.author != null ? !this.author.equals(linkBlock.author) : linkBlock.author != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(linkBlock.image) : linkBlock.image != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(linkBlock.data) : linkBlock.data != null) {
            return false;
        }
        if (this.siteName != null ? !this.siteName.equals(linkBlock.siteName) : linkBlock.siteName != null) {
            return false;
        }
        if (this.articleId != null ? !this.articleId.equals(linkBlock.articleId) : linkBlock.articleId != null) {
            return false;
        }
        return this.url != null ? this.url.equals(linkBlock.url) : linkBlock.url == null;
    }

    public int hashCode() {
        int result2 = this.type != null ? this.type.hashCode() : 0;
        result2 = 31 * result2 + (this.text != null ? this.text.hashCode() : 0);
        result2 = 31 * result2 + (this.title != null ? this.title.hashCode() : 0);
        result2 = 31 * result2 + (this.description != null ? this.description.hashCode() : 0);
        result2 = 31 * result2 + (this.linkType != null ? this.linkType.hashCode() : 0);
        result2 = 31 * result2 + (this.author != null ? this.author.hashCode() : 0);
        result2 = 31 * result2 + (this.image != null ? this.image.hashCode() : 0);
        result2 = 31 * result2 + (this.data != null ? this.data.hashCode() : 0);
        result2 = 31 * result2 + (this.siteName != null ? this.siteName.hashCode() : 0);
        result2 = 31 * result2 + (this.articleId != null ? this.articleId.hashCode() : 0);
        result2 = 31 * result2 + (this.url != null ? this.url.hashCode() : 0);
        return result2;
    }

    public int describeContents() {
        return 0;
    }

    protected Link(Parcel in) {
        this.type = BlockType.typeValueOf(in.readString());
        this.text = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.linkType = in.readString();
        this.siteName = in.readString();
        this.articleId = in.readString();
        this.url = in.readString();
        this.author = (Author)in.readParcelable(Author.class.getClassLoader());
        this.image = (Image)in.readParcelable(Image.class.getClassLoader());
        this.data = new HashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.data.put(key, value);
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type.name());
        dest.writeString(this.text);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeString(this.linkType);
        dest.writeString(this.siteName);
        dest.writeString(this.articleId);
        dest.writeString(this.url);
        dest.writeParcelable((Parcelable)this.author, flags);
        dest.writeParcelable((Parcelable)this.image, flags);
        dest.writeInt(this.data.size());
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    public static final class Builder {
        String type;
        String text;
        String title;
        String description;
        String linkType;
        String siteName;
        String articleId;
        Author author;
        Image image;
        Map<String, String> data;
        String url;

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withLinkType(String linkType) {
            this.linkType = linkType;
            return this;
        }

        public Builder withSiteName(String siteName) {
            this.siteName = siteName;
            return this;
        }

        public Builder withArticleId(String articleId) {
            this.articleId = articleId;
            return this;
        }

        public Builder withAuthor(Author author) {
            this.author = author;
            return this;
        }

        public Builder withImage(Image image) {
            this.image = image;
            return this;
        }

        public Builder withData(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public Builder withType(String type2) {
            this.type = type2;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Link build() {
            return new Link(this);
        }
    }
}

