/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.LinkBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.lib.models.Link;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.commons.HtmlCompat;

class LinkCard
implements LinkBlock {
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;
    private final String conversationId;

    LinkCard(StyleType style, Provider<AppConfig> appConfigProvider, String conversationId2) {
        this.style = style;
        this.appConfigProvider = appConfigProvider;
        this.conversationId = conversationId2;
    }

    @Override
    public View addLinkBlock(Link link, BlockMetadata blockMetadata, ViewGroup parent) {
        if (this.shouldDisplayLink()) {
            return this.createLinkBlock(link, parent, blockMetadata.isSingleObject(), blockMetadata.isLastObject());
        }
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml(link.getText()));
        return textView;
    }

    private boolean shouldDisplayLink() {
        return StyleType.ADMIN.equals((Object)this.style) || StyleType.CHAT_FULL.equals((Object)this.style);
    }

    private View createLinkBlock(final Link link, ViewGroup parent, boolean isOnlyPart, boolean isLastObject) {
        AppConfig appConfig = this.appConfigProvider.get();
        final Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        LinearLayout rootLayout = (LinearLayout)layoutInflater.inflate(R.layout.intercom_link_block, parent, false);
        TextView title = (TextView)rootLayout.findViewById(R.id.title);
        ColorUtils.setTextColorPrimaryOrDark(title, appConfig);
        title.setText((CharSequence)link.getTitle());
        this.setUpDescription(link, (TextView)rootLayout.findViewById(R.id.description));
        ImageView avatar = (ImageView)rootLayout.findViewById(R.id.avatar);
        TextView authorTextView = (TextView)rootLayout.findViewById(R.id.author);
        String authorName = link.getAuthor().getFirstName();
        if (TextUtils.isEmpty((CharSequence)authorName)) {
            avatar.setVisibility(8);
            authorTextView.setVisibility(8);
        } else {
            this.addAuthorDetails(link, avatar, authorTextView, authorName);
        }
        if (!isOnlyPart) {
            if ("educate.article".equals(link.getLinkType())) {
                rootLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (context instanceof Activity) {
                            Intent intent = ArticleActivity.buildIntent(context, new ArticleActivity.ArticleActivityArguments(link.getArticleId(), "conversation"));
                            context.startActivity(intent);
                        }
                    }
                });
            }
            BackgroundUtils.setBackground((View)rootLayout, ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_conversation_card_background));
            BlockUtils.setMarginBottom((View)rootLayout, 8);
            int padding = context.getResources().getDimensionPixelSize(R.dimen.intercom_link_padding);
            rootLayout.setPadding(padding, padding, padding, padding);
            BlockUtils.setLayoutMarginsAndGravity((View)rootLayout, 0x800003, isLastObject);
        }
        return rootLayout;
    }

    private void setUpDescription(Link link, TextView description) {
        String descriptionText = link.getDescription();
        if (TextUtils.isEmpty((CharSequence)descriptionText)) {
            description.setVisibility(8);
        } else {
            description.setVisibility(0);
            description.setText((CharSequence)descriptionText);
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private void addAuthorDetails(Link link, ImageView avatar, TextView authorTextView, String authorName) {
        avatar.setVisibility(0);
        authorTextView.setVisibility(0);
        SpannableString firstNameSpannable = new SpannableString((CharSequence)authorName);
        firstNameSpannable.setSpan((Object)new StyleSpan(1), 0, authorName.length(), 33);
        authorTextView.setText((CharSequence)("Written by " + firstNameSpannable));
        int avatarSize = avatar.getResources().getDimensionPixelSize(R.dimen.intercom_avatar_size);
        Avatar authorAvatar = Avatar.create(link.getAuthor().getAvatar(), "");
        AvatarUtils.createAvatar(authorAvatar, avatar, avatarSize, this.appConfigProvider.get());
    }
}

