/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.google.gson.Gson;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.MessengerCardBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.commons.HtmlCompat;

public class MessengerCard
implements MessengerCardBlock {
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final String conversationId;

    public MessengerCard(Provider<AppConfig> appConfigProvider2, Gson gson, MetricTracker metricTracker, String conversationId2) {
        this.appConfigProvider = appConfigProvider2;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId2;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View addCard(String text, String fallbackUrl, BlockMetadata blockMetadata, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
            return this.textFallback(text, parent);
        }
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        FrameLayout rootLayout = (FrameLayout)layoutInflater.inflate(R.layout.intercom_messenger_card_block, parent, false);
        LayoutTransition layoutTransition = rootLayout.getLayoutTransition();
        layoutTransition.enableTransitionType(4);
        ProgressBar loadingView = (ProgressBar)rootLayout.findViewById(R.id.loading_view);
        CardWebView webView = MessengerCardWebViewPresenter.createCardWebView(context);
        rootLayout.addView((View)webView);
        int primaryColor = ColorUtils.primaryOrDarkColor(webView.getContext(), this.appConfigProvider.get());
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(webView, (View)loadingView, fallbackUrl, primaryColor, this.gson, this.metricTracker, context.getCacheDir(), this.conversationId, false, context);
        presenter.setUpWebView();
        webView.loadUrl(fallbackUrl);
        return rootLayout;
    }

    private View textFallback(String text, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml(text));
        return textView;
    }
}

