/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.HeadingBlock;
import io.intercom.android.sdk.blocks.lib.interfaces.SubheadingBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.models.CustomizationColorsModel;
import io.intercom.android.sdk.utilities.AccessibilityUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;

class Heading
implements HeadingBlock,
SubheadingBlock {
    private static final int LARGE_TEXT_SP = 24;
    private static final int MEDIUM_TEXT_SP = 20;
    private static final int SMALL_TEXT_SP = 15;
    private static final int LARGE_MARGIN_BOTTOM_DP = 32;
    private static final int MARGIN_BOTTOM_DP = 16;
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;

    Heading(StyleType style2, Provider<AppConfig> appConfigProvider2) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider2;
    }

    @Override
    public View addHeading(Spanned text, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        int colour;
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        textView.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        ConfigModules configModules = this.appConfigProvider.get().getConfigModules();
        if (configModules != null) {
            CustomizationColorsModel actionColorsContrastWhite = configModules.getCustomization().getActionContrastWhite();
            CustomizationColorsModel actionColors = actionColorsContrastWhite == null ? configModules.getCustomization().getAction() : actionColorsContrastWhite;
            colour = Color.parseColor((String)actionColors.getBackgroundColor());
        } else {
            colour = -16777216;
        }
        switch (this.style) {
            case POST: {
                int lightColour = ColorUtils.lightenColor(colour);
                this.styleAnnouncementHeading(textView, lightColour, 24, 32);
                FontUtils.setRobotoLightTypeface(textView);
                break;
            }
            case NOTE: {
                int color2 = ColorUtils.primaryOrBlackAccessibility(context, this.appConfigProvider.get());
                this.styleAnnouncementHeading(textView, color2, 24, 32);
                break;
            }
            case ARTICLE: {
                this.styleAnnouncementHeading(textView, ColorUtils.primaryOrDarkColor(context, this.appConfigProvider.get()), 24, 32);
                break;
            }
            case CONTAINER_CARD: {
                this.styleAnnouncementHeading(textView, colour, 20, 32);
                break;
            }
            case CHAT_FULL: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                textView.setTypeface(null, 1);
                break;
            }
            case CAROUSEL: {
                this.styleCarouselHeading1(textView, blockMetadata);
                break;
            }
            default: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                textView.setTypeface(null, 1);
            }
        }
        textView.setText((CharSequence)text);
        textView.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textView, alignment.getGravity(), blockMetadata.isLastObject());
        AccessibilityUtils.INSTANCE.removeClickAbilityAnnouncement((View)textView);
        AccessibilityUtils.INSTANCE.addHeadingAnnouncement((View)textView);
        return textView;
    }

    @Override
    public View addSubheading(Spanned text, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        int appColour;
        Context context = parent.getContext();
        TextView textView = new TextView(context);
        textView.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        BlockUtils.createLayoutParams((View)textView, -2, -2);
        ConfigModules configModules = this.appConfigProvider.get().getConfigModules();
        if (configModules != null) {
            CustomizationColorsModel actionColorsContrastWhite = configModules.getCustomization().getActionContrastWhite();
            CustomizationColorsModel actionColors = actionColorsContrastWhite == null ? configModules.getCustomization().getAction() : actionColorsContrastWhite;
            appColour = Color.parseColor((String)actionColors.getBackgroundColor());
        } else {
            appColour = -16777216;
        }
        switch (this.style) {
            case POST: {
                this.styleAnnouncementHeading(textView, ColorUtils.lightenColor(appColour), 15, 16);
                FontUtils.setRobotoLightTypeface(textView);
                break;
            }
            case ARTICLE: {
                this.styleAnnouncementHeading(textView, ColorUtils.primaryOrDarkColor(context, this.appConfigProvider.get()), 15, 16);
                break;
            }
            case NOTE: 
            case CONTAINER_CARD: {
                this.styleAnnouncementHeading(textView, appColour, 15, 16);
                break;
            }
            case CHAT_FULL: {
                this.styleChatHeading(textView, ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
                break;
            }
            case CAROUSEL: {
                this.styleCarouselHeading2(textView, blockMetadata);
                break;
            }
            default: {
                this.styleChatHeading(textView, appColour);
            }
        }
        textView.setText((CharSequence)text);
        textView.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textView, alignment.getGravity(), blockMetadata.isLastObject());
        AccessibilityUtils.INSTANCE.removeClickAbilityAnnouncement((View)textView);
        AccessibilityUtils.INSTANCE.addHeadingAnnouncement((View)textView);
        return textView;
    }

    private void styleChatHeading(TextView textview, int colour) {
        textview.setTextSize(15.0f);
        textview.setTextColor(colour);
        textview.setLinkTextColor(colour);
        BlockUtils.setSmallLineSpacing(textview);
        BlockUtils.setDefaultMarginBottom((View)textview);
    }

    private void styleAnnouncementHeading(TextView textview, @ColorInt int color2, int textSizeSp, int marginBottomDp) {
        textview.setTextSize((float)textSizeSp);
        textview.setTextColor(color2);
        textview.setLinkTextColor(color2);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        BlockUtils.setLargeLineSpacing(textview);
        BlockUtils.setMarginBottom((View)textview, marginBottomDp);
    }

    private void styleCarouselHeading1(TextView textView, BlockMetadata blockMetadata) {
        this.applyGenericCarouselHeadingStyle(textView, blockMetadata);
        textView.setTextSize(48.0f);
        textView.setLineSpacing((float)ScreenUtils.dpToPx(8.0f, textView.getContext()), 1.0f);
    }

    private void styleCarouselHeading2(TextView textView, BlockMetadata blockMetadata) {
        this.applyGenericCarouselHeadingStyle(textView, blockMetadata);
        textView.setTextSize(34.0f);
        textView.setLineSpacing((float)ScreenUtils.dpToPx(6.0f, textView.getContext()), 1.0f);
    }

    @SuppressLint(value={"WrongConstant"})
    private void applyGenericCarouselHeadingStyle(TextView textView, BlockMetadata blockMetadata) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setBreakStrategy(0);
        }
        textView.setTypeface(null, 1);
        BlockUtils.setMarginBottom((View)textView, 16);
        String textColor = blockMetadata.getAppearance().getTextColor();
        if (!textColor.isEmpty()) {
            int color2 = Color.parseColor((String)textColor);
            textView.setTextColor(color2);
            textView.setLinkTextColor(color2);
        }
    }
}

