/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.FileProvider;
import coil.request.ImageRequest;
import coil.transform.CircleCropTransformation;
import coil.transform.Transformation;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.BitmapUtilsKt;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import io.intercom.android.sdk.views.AvatarDefaultDrawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a*\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001aj\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2:\u0010\u0014\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0015\u0012\u0013\u0018\u00010\t\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00110\u0015H\u0000\u001a\u001a\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"BIG_PICTURE_HEIGHT_DP", "", "BIG_PICTURE_WIDTH_DP", "LARGE_ICON_SIZE_DP", "getBitmapUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "bitmap", "Landroid/graphics/Bitmap;", "loadAvatarBitmapBlocking", "imageUrl", "", "authorName", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "loadBitmaps", "", "contentImageUrl", "avatarImageUrl", "onComplete", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "contentBitmap", "avatarBitmap", "loadContentBitmapBlocking", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nIntercomPushBitmapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomPushBitmapUtils.kt\nio/intercom/android/sdk/m5/push/IntercomPushBitmapUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class IntercomPushBitmapUtilsKt {
    private static final float LARGE_ICON_SIZE_DP = 48.0f;
    private static final float BIG_PICTURE_WIDTH_DP = 512.0f;
    private static final float BIG_PICTURE_HEIGHT_DP = 256.0f;

    public static final void loadBitmaps(@NotNull Context context, @NotNull String contentImageUrl, @NotNull String avatarImageUrl, @NotNull String authorName, @NotNull Function2<? super Bitmap, ? super Bitmap, Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentImageUrl, (String)"contentImageUrl");
        Intrinsics.checkNotNullParameter((Object)avatarImageUrl, (String)"avatarImageUrl");
        Intrinsics.checkNotNullParameter((Object)authorName, (String)"authorName");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        AppConfig appConfig = Injector.get().getAppConfigProvider().get();
        Ref.ObjectRef contentBitmap = new Ref.ObjectRef();
        Ref.ObjectRef avatarBitmap = new Ref.ObjectRef();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onComplete, (Ref.ObjectRef<Bitmap>)contentBitmap, (Ref.ObjectRef<Bitmap>)avatarBitmap, context, contentImageUrl, avatarImageUrl, authorName, appConfig, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<Bitmap, Bitmap, Unit> $onComplete;
            final /* synthetic */ Ref.ObjectRef<Bitmap> $contentBitmap;
            final /* synthetic */ Ref.ObjectRef<Bitmap> $avatarBitmap;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $contentImageUrl;
            final /* synthetic */ String $avatarImageUrl;
            final /* synthetic */ String $authorName;
            final /* synthetic */ AppConfig $appConfig;
            {
                this.$onComplete = $onComplete;
                this.$contentBitmap = $contentBitmap;
                this.$avatarBitmap = $avatarBitmap;
                this.$context = $context;
                this.$contentImageUrl = $contentImageUrl;
                this.$avatarImageUrl = $avatarImageUrl;
                this.$authorName = $authorName;
                this.$appConfig = $appConfig;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        contentBitmapJob = BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$contentBitmap, this.$context, this.$contentImageUrl, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<Bitmap> $contentBitmap;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ String $contentImageUrl;
                            {
                                this.$contentBitmap = $contentBitmap;
                                this.$context = $context;
                                this.$contentImageUrl = $contentImageUrl;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$contentBitmap.element = IntercomPushBitmapUtilsKt.access$loadContentBitmapBlocking(this.$context, this.$contentImageUrl);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        avatarBitmapJob = BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$avatarBitmap, this.$context, this.$avatarImageUrl, this.$authorName, this.$appConfig, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<Bitmap> $avatarBitmap;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ String $avatarImageUrl;
                            final /* synthetic */ String $authorName;
                            final /* synthetic */ AppConfig $appConfig;
                            {
                                this.$avatarBitmap = $avatarBitmap;
                                this.$context = $context;
                                this.$avatarImageUrl = $avatarImageUrl;
                                this.$authorName = $authorName;
                                this.$appConfig = $appConfig;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AppConfig appConfig = this.$appConfig;
                                        Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"appConfig");
                                        this.$avatarBitmap.element = IntercomPushBitmapUtilsKt.access$loadAvatarBitmapBlocking(this.$context, this.$avatarImageUrl, this.$authorName, appConfig);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = avatarBitmapJob;
                        this.label = 1;
                        v0 = contentBitmapJob.join((Continuation)this);
                        ** if (v0 != var5_2) goto lbl15
lbl14:
                        // 1 sources

                        return var5_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl22
                    }
                    case 1: {
                        avatarBitmapJob = (Job)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = avatarBitmapJob.join((Continuation)this);
                        ** if (v1 != var5_2) goto lbl27
lbl26:
                        // 1 sources

                        return var5_2;
lbl27:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Throwable var3_5) {
                            throw var3_5;
                        }
                        finally {
                            this.$onComplete.invoke(this.$contentBitmap.element, this.$avatarBitmap.element);
                        }
lbl40:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void loadBitmaps$default(Context context, String string2, String string3, String string4, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        IntercomPushBitmapUtilsKt.loadBitmaps(context, string2, string3, string4, (Function2<? super Bitmap, ? super Bitmap, Unit>)function2);
    }

    private static final Bitmap loadContentBitmapBlocking(Context context, String contentImageUrl) {
        Bitmap bitmap;
        if (StringsKt.isBlank((CharSequence)contentImageUrl)) {
            bitmap = null;
        } else {
            Drawable drawable2;
            int iconWidth = ScreenUtils.dpToPx(512.0f, context);
            int iconHeight = ScreenUtils.dpToPx(256.0f, context);
            Drawable defaultDrawable = AppCompatResources.getDrawable((Context)context, (int)R.drawable.intercom_push_image_load_failes);
            ImageRequest imageRequest = new ImageRequest.Builder(context).dispatcher(Dispatchers.getIO()).data((Object)contentImageUrl).error(defaultDrawable).build();
            Drawable drawable3 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
            if (drawable3 == null) {
                drawable3 = defaultDrawable;
            }
            Drawable drawable4 = drawable2 = drawable3;
            if (drawable4 != null) {
                Drawable it = drawable4;
                boolean bl = false;
                bitmap = BitmapUtilsKt.drawableToBitmap(it, iconWidth, iconHeight);
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private static final Bitmap loadAvatarBitmapBlocking(Context context, String imageUrl, String authorName, AppConfig appConfig) {
        Bitmap bitmap;
        if (StringsKt.isBlank((CharSequence)imageUrl) && StringsKt.isBlank((CharSequence)authorName)) {
            bitmap = null;
        } else {
            Drawable drawable2;
            int iconSize = ScreenUtils.dpToPx(48.0f, context);
            if (StringsKt.isBlank((CharSequence)imageUrl) && !StringsKt.isBlank((CharSequence)authorName)) {
                drawable2 = AvatarUtils.getInitialsDrawable(NameUtils.getInitial(authorName), appConfig);
            } else {
                AvatarDefaultDrawable defaultDrawable = AvatarUtils.getDefaultDrawable(context, appConfig);
                Transformation[] transformationArray = new Transformation[]{new CircleCropTransformation()};
                ImageRequest imageRequest = new ImageRequest.Builder(context).error((Drawable)defaultDrawable).transformations(transformationArray).data((Object)imageUrl).dispatcher(Dispatchers.getIO()).size(iconSize, iconSize).build();
                drawable2 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
                if (drawable2 == null) {
                    drawable2 = defaultDrawable;
                }
            }
            Drawable drawable3 = drawable2;
            Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable");
            bitmap = BitmapUtilsKt.drawableToBitmap(drawable3, iconSize, iconSize);
        }
        return bitmap;
    }

    @Nullable
    public static final Uri getBitmapUri(@NotNull Context context, @NotNull Bitmap bitmap) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            File imageFolder = new File(context.getCacheDir(), "images");
            imageFolder.mkdirs();
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
            String fileName = string2;
            File file = new File(imageFolder, fileName + ".png");
            FileOutputStream outputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
            uri = FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".IntercomFileProvider"), (File)file);
        }
        catch (Exception e) {
            uri = null;
        }
        return uri;
    }

    public static final /* synthetic */ Bitmap access$loadContentBitmapBlocking(Context context, String contentImageUrl) {
        return IntercomPushBitmapUtilsKt.loadContentBitmapBlocking(context, contentImageUrl);
    }

    public static final /* synthetic */ Bitmap access$loadAvatarBitmapBlocking(Context context, String imageUrl, String authorName, AppConfig appConfig) {
        return IntercomPushBitmapUtilsKt.loadAvatarBitmapBlocking(context, imageUrl, authorName, appConfig);
    }
}

