/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.coil;

import android.graphics.Bitmap;
import androidx.compose.foundation.shape.RoundedCornerShape;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import coil.size.Size;
import coil.transform.RoundedCornersTransformation;
import coil.transform.Transformation;
import io.intercom.android.sdk.m5.components.avatar.AvatarIconKt;
import io.intercom.android.sdk.m5.components.avatar.AvatarShape;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lio/intercom/android/sdk/utilities/coil/AvatarShapeTransformation;", "Lcoil/transform/Transformation;", "avatarShape", "Lio/intercom/android/sdk/m5/components/avatar/AvatarShape;", "(Lio/intercom/android/sdk/m5/components/avatar/AvatarShape;)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "transform", "Landroid/graphics/Bitmap;", "input", "size", "Lcoil/size/Size;", "(Landroid/graphics/Bitmap;Lcoil/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intercom-sdk-base_release"})
public final class AvatarShapeTransformation
implements Transformation {
    @NotNull
    private final AvatarShape avatarShape;

    public AvatarShapeTransformation(@NotNull AvatarShape avatarShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)avatarShape), (String)"avatarShape");
        this.avatarShape = avatarShape;
    }

    @NotNull
    public String getCacheKey() {
        return this.avatarShape.name() + this.getClass().getName();
    }

    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size, @NotNull Continuation<? super Bitmap> $completion) {
        RoundedCornerShape shape = AvatarIconKt.getComposeShape(this.avatarShape);
        long inputSize = SizeKt.Size((float)input.getWidth(), (float)input.getHeight());
        Density density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        return new RoundedCornersTransformation(shape.getTopStart().toPx-TmRCtEA(inputSize, density), shape.getTopEnd().toPx-TmRCtEA(inputSize, density), shape.getBottomStart().toPx-TmRCtEA(inputSize, density), shape.getBottomEnd().toPx-TmRCtEA(inputSize, density)).transform(input, size, $completion);
    }
}

