/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import androidx.core.graphics.drawable.IconCompat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.m5.push.ConversationReplyReceiver;
import io.intercom.android.sdk.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"KEY_CONVERSATION_ID", "", "KEY_TEXT_REPLY", "buildContextualAction", "Landroidx/core/app/NotificationCompat$Action;", "context", "Landroid/content/Context;", "url", "buildReplyAction", "conversationId", "getAttachmentIntent", "Landroid/app/PendingIntent;", "getReplyIntent", "intercom-sdk-base_release"})
public final class ConversationActionHandlerKt {
    @NotNull
    public static final String KEY_TEXT_REPLY = "io.intercom.android.sdk.INTERCOM_KEY_TEXT_REPLY";
    @NotNull
    public static final String KEY_CONVERSATION_ID = "io.intercom.android.sdk.INTERCOM_KEY_CONVERSATION_ID";

    @NotNull
    public static final NotificationCompat.Action buildReplyAction(@NotNull Context context, @NotNull String conversationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        RemoteInput remoteInput = new RemoteInput.Builder(KEY_TEXT_REPLY).setLabel((CharSequence)context.getString(R.string.intercom_reply)).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"build(...)");
        RemoteInput remoteInput2 = remoteInput;
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(R.drawable.intercom_send, (CharSequence)context.getString(R.string.intercom_reply), ConversationActionHandlerKt.getReplyIntent(context, conversationId)).addRemoteInput(remoteInput2).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"build(...)");
        return action;
    }

    private static final PendingIntent getReplyIntent(Context context, String conversationId) {
        Intent intent;
        int requestCode = conversationId.hashCode();
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        Intent it = intent = new Intent(context, ConversationReplyReceiver.class);
        boolean bl = false;
        it.putExtra(KEY_CONVERSATION_ID, conversationId);
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)intent2, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getBroadcast(...)");
        return pendingIntent;
    }

    @NotNull
    public static final NotificationCompat.Action buildContextualAction(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        IconCompat iconCompat = IconCompat.createWithResource((Context)context, (int)R.drawable.intercom_ic_attachment);
        Intrinsics.checkNotNullExpressionValue((Object)iconCompat, (String)"createWithResource(...)");
        IconCompat icon = iconCompat;
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(icon, (CharSequence)"Open Attachment", ConversationActionHandlerKt.getAttachmentIntent(context, url)).setContextual(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"build(...)");
        return action;
    }

    private static final PendingIntent getAttachmentIntent(Context context, String url) {
        Intent intent;
        int requestCode = url.hashCode();
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        Intent $this$getAttachmentIntent_u24lambda_u241 = intent = new Intent("android.intent.action.VIEW");
        boolean bl = false;
        $this$getAttachmentIntent_u24lambda_u241.setData(Uri.parse((String)url));
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)intent2, (int)flags);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(...)");
        return pendingIntent;
    }
}

