/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import androidx.exifinterface.media.ExifInterface;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import io.intercom.android.sdk.utilities.TimeFormatterExtKt;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"getImageData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "intercom-sdk-base_release"})
public final class URIExtensionsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MediaData.Media getImageData(@NotNull Uri $this$getImageData, @NotNull Context context) {
        MediaData.Media media;
        Intrinsics.checkNotNullParameter((Object)$this$getImageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query($this$getImageData, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                cursor2.moveToFirst();
                String fileName = cursor2.getString(cursor2.getColumnIndexOrThrow("_display_name"));
                String mimeType = cursor2.getColumnIndex("mime_type") != -1 ? cursor2.getString(cursor2.getColumnIndexOrThrow("mime_type")) : "";
                int size = cursor2.getInt(cursor2.getColumnIndexOrThrow("_size"));
                int width = 0;
                int height = 0;
                Intrinsics.checkNotNull((Object)mimeType);
                if (!StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"application", (boolean)false, (int)2, null)) {
                    InputStream inputStream = contentResolver.openInputStream($this$getImageData);
                    if (inputStream != null) {
                        Closeable closeable2 = inputStream;
                        Throwable throwable2 = null;
                        try {
                            InputStream it = (InputStream)closeable2;
                            boolean bl2 = false;
                            ExifInterface exif = new ExifInterface(it);
                            width = exif.getAttributeInt("ImageWidth", 640);
                            height = exif.getAttributeInt("ImageLength", 480);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                }
                long videoDurationInMs = cursor2.getColumnIndex("duration") != -1 ? cursor2.getLong(cursor2.getColumnIndexOrThrow("duration")) : 0L;
                int n = width;
                int n2 = height;
                String string2 = TimeFormatterExtKt.millisecondsToFormatTime(videoDurationInMs);
                Intrinsics.checkNotNull((Object)fileName);
                MediaData.Media media2 = new MediaData.Media(null, n, n2, mimeType, size, fileName, $this$getImageData, string2, 1, null);
                media = media2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        media = null;
        return media;
    }
}

