/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils;

import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Part;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u000e"}, d2={"shouldConcatenate", "", "part", "Lio/intercom/android/sdk/models/Part;", "nextPart", "hasNextConcatPart", "", "index", "", "hasPreviousConcatPart", "hasVideoAttachment", "isAttributeCollector", "isTypingPart", "nextPartFromSameParticipant", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nPartExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/m5/conversation/utils/PartExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1747#2,3:32\n*S KotlinDebug\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/m5/conversation/utils/PartExtensionsKt\n*L\n15#1:32,3\n*E\n"})
public final class PartExtensionsKt {
    public static final boolean nextPartFromSameParticipant(@NotNull Part $this$nextPartFromSameParticipant, @NotNull Part nextPart) {
        Intrinsics.checkNotNullParameter((Object)$this$nextPartFromSameParticipant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        return Intrinsics.areEqual((Object)$this$nextPartFromSameParticipant.getParticipantId(), (Object)nextPart.getParticipantId());
    }

    public static final boolean isTypingPart(@NotNull Part $this$isTypingPart) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypingPart, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isTypingPart.getMessageStyle(), (Object)"admin_is_typing_style");
    }

    public static final boolean isAttributeCollector(@NotNull Part $this$isAttributeCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$isAttributeCollector, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isAttributeCollector.getMessageStyle(), (Object)"attribute_collector") && !((Collection)$this$isAttributeCollector.getForm().getAttributes()).isEmpty();
    }

    public static final boolean hasVideoAttachment(@NotNull Part $this$hasVideoAttachment) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasVideoAttachment, (String)"<this>");
            List<Attachments> list = $this$hasVideoAttachment.getAttachments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAttachments(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Attachments it = (Attachments)element$iv;
                    boolean bl2 = false;
                    String string2 = it.getContentType();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getContentType(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"video", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasPreviousConcatPart(@NotNull List<? extends Part> $this$hasPreviousConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPart, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasPreviousConcatPart.get(index - 1), $this$hasPreviousConcatPart.get(index));
    }

    public static final boolean hasNextConcatPart(@NotNull List<? extends Part> $this$hasNextConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPart, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasNextConcatPart.get(index), $this$hasNextConcatPart.get(index + 1));
    }

    private static final boolean shouldConcatenate(Part part, Part nextPart) {
        return PartExtensionsKt.nextPartFromSameParticipant(part, nextPart) && Math.abs(nextPart.getCreatedAt() - part.getCreatedAt()) < TimeUnit.MINUTES.toSeconds(3L) && !PartExtensionsKt.isTypingPart(part) && !PartExtensionsKt.isTypingPart(nextPart) && !part.isLinkCard() && !nextPart.isLinkCard() && part.isEvent() == false && nextPart.isEvent() == false && !PartExtensionsKt.isAttributeCollector(part) && !PartExtensionsKt.isAttributeCollector(nextPart) && part.isQuickReplyOnly() == false && nextPart.isQuickReplyOnly() == false;
    }
}

