/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.intercom.twig.Twig;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.LogEventResponse;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.carousel.CarouselResponse;
import io.intercom.android.sdk.models.events.failure.FetchCarouselFailedEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CallbackHolder {
    final Store<State> store;
    private static final Twig TWIG = LumberMill.getLogger();

    CallbackHolder(Store<State> store) {
        this.store = store;
    }

    BaseCallback<LogEventResponse.Builder> logEventCallback() {
        return new BaseCallback<LogEventResponse.Builder>(){

            @Override
            public void onSuccess(LogEventResponse.Builder builder) {
                LogEventResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
                CallbackHolder.this.store.dispatch(Actions.carouselUpdated(response.getCarousel()));
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                UsersResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
            }
        };
    }

    Callback<Void> loggingCallback(final String action) {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                TWIG.internal(action + " success");
            }

            public void onFailure(Call<Void> call, Throwable throwable) {
                TWIG.internal(action + " failure");
            }
        };
    }

    Callback<CarouselResponse.Builder> getCarouselCallback(final String carouselId) {
        return new BaseCallback<CarouselResponse.Builder>(){

            @Override
            protected void onSuccess(CarouselResponse.Builder builder) {
                CallbackHolder.this.store.dispatch(Actions.programmaticCarouselSuccess(builder.build().carousel().build()));
            }

            @Override
            protected void onError(ErrorObject errorDetails) {
                CallbackHolder.this.store.dispatch(Actions.programmaticCarouselError(FetchCarouselFailedEvent.create(carouselId, errorDetails)));
            }
        };
    }
}

