/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.user;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.api.PlatformIdentifierUtilKt;
import io.intercom.android.sdk.utilities.commons.DeviceUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DeviceData {
    private static final String PREFS_PUSH_TOKEN = "push_token";

    public static Map<String, Object> generateDeviceData(Context context) {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        deviceData.put("platform_version", Build.VERSION.RELEASE);
        deviceData.put("sdk_type", PlatformIdentifierUtilKt.getPlatformIdentifier(context));
        deviceData.put("platform", Build.MODEL);
        deviceData.put("browser", "Intercom-Android-SDK");
        deviceData.put("version", DeviceUtils.getAppVersion(context));
        deviceData.put("application", DeviceData.getApplicationName(context));
        deviceData.put("application_id", DeviceUtils.getAppName(context));
        deviceData.put("language", Locale.getDefault().getDisplayLanguage());
        String token = DeviceData.getPreferences(context).getString(PREFS_PUSH_TOKEN, "");
        if (!token.isEmpty()) {
            deviceData.put("device_token", token);
        }
        return deviceData;
    }

    public static boolean hasCachedDeviceToken(Context context, String pushToken) {
        return pushToken.equals(DeviceData.getDeviceToken(context));
    }

    public static void cacheDeviceToken(Context context, String pushToken) {
        DeviceData.getPreferences(context).edit().putString(PREFS_PUSH_TOKEN, pushToken).apply();
    }

    public static String getDeviceToken(Context context) {
        return DeviceData.getPreferences(context).getString(PREFS_PUSH_TOKEN, "");
    }

    private static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
    }

    @VisibleForTesting
    static String getApplicationName(Context context) {
        ApplicationInfo applicationInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getApplicationInfo().packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "";
        }
        String appTitle = applicationInfo != null ? packageManager.getApplicationLabel(applicationInfo) : "";
        return appTitle.toString();
    }
}

