/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.data;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.core.content.ContextCompat;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.models.TicketType;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppConfigKt;
import io.intercom.android.sdk.m5.data.IntercomEvent;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.utilities.extensions.ConversationExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0010J$\u0010#\u001a\u00020\u001e2\b\b\u0002\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0'J\u0019\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\rH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0016\u0010(\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\rJ\u0012\u0010+\u001a\u0004\u0018\u00010\n2\b\u0010,\u001a\u0004\u0018\u00010-J\u0017\u0010.\u001a\u0004\u0018\u00010\u00102\b\u0010,\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u00100J\"\u00101\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001e0'J\u0006\u00103\u001a\u00020\u001eJ\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u0007H\u0002J\u000e\u00106\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u000207R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_config", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/identity/AppConfig;", "_conversations", "", "Lio/intercom/android/sdk/models/Conversation;", "_event", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/intercom/android/sdk/m5/data/IntercomEvent;", "_ticketTypes", "", "Lio/intercom/android/sdk/blocks/lib/models/TicketType;", "config", "Lkotlinx/coroutines/flow/StateFlow;", "getConfig", "()Lkotlinx/coroutines/flow/StateFlow;", "conversations", "", "getConversations", "()Ljava/util/Set;", "event", "Lkotlinx/coroutines/flow/SharedFlow;", "getEvent", "()Lkotlinx/coroutines/flow/SharedFlow;", "addConversations", "", "newConversations", "", "addTicketType", "ticketType", "configUpdates", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onNewAppConfig", "Lkotlin/Function1;", "emitEvent", "intercomEvent", "(Lio/intercom/android/sdk/m5/data/IntercomEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConversationById", "id", "", "getTicketTypeById", "", "(Ljava/lang/Integer;)Lio/intercom/android/sdk/blocks/lib/models/TicketType;", "listenToEvents", "onNewEvent", "resetConfig", "updateAppConfig", "newAppConfig", "updateConfig", "Lio/intercom/android/sdk/models/Config;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nIntercomDataLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomDataLayer.kt\nio/intercom/android/sdk/m5/data/IntercomDataLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n288#2,2:150\n288#2,2:152\n1054#2:154\n1655#2,8:155\n*S KotlinDebug\n*F\n+ 1 IntercomDataLayer.kt\nio/intercom/android/sdk/m5/data/IntercomDataLayer\n*L\n55#1:150,2\n69#1:152,2\n76#1:154\n77#1:155,8\n*E\n"})
public final class IntercomDataLayer {
    @NotNull
    private final Context context;
    @NotNull
    private final List<TicketType> _ticketTypes;
    @NotNull
    private final Set<Conversation> _conversations;
    @NotNull
    private final Set<Conversation> conversations;
    @NotNull
    private final MutableSharedFlow<IntercomEvent> _event;
    @NotNull
    private final SharedFlow<IntercomEvent> event;
    @NotNull
    private final MutableStateFlow<AppConfig> _config;
    @NotNull
    private final StateFlow<AppConfig> config;

    public IntercomDataLayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this._ticketTypes = new ArrayList();
        this._conversations = new LinkedHashSet();
        this.conversations = this._conversations;
        this._event = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.event = (SharedFlow)this._event;
        SharedPreferences prefs = this.context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        Intrinsics.checkNotNullExpressionValue((Object)prefs, (String)"prefs");
        this._config = StateFlowKt.MutableStateFlow((Object)AppConfigKt.getAppConfig(prefs, ContextCompat.getColor((Context)this.context, (int)R.color.intercom_main_blue), new NexusConfig()));
        this.config = FlowKt.asStateFlow(this._config);
    }

    @NotNull
    public final Set<Conversation> getConversations() {
        return this.conversations;
    }

    @NotNull
    public final SharedFlow<IntercomEvent> getEvent() {
        return this.event;
    }

    @NotNull
    public final StateFlow<AppConfig> getConfig() {
        return this.config;
    }

    @Nullable
    public final TicketType getTicketTypeById(@Nullable Integer id2) {
        TicketType ticketType;
        Integer n = id2;
        if (n != null) {
            Object v1;
            block3: {
                int it = ((Number)n).intValue();
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this._ticketTypes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TicketType ticketType2 = (TicketType)element$iv;
                    boolean bl2 = false;
                    if (!(ticketType2.getId() == it)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ticketType = v1;
        } else {
            ticketType = null;
        }
        return ticketType;
    }

    public final void addTicketType(@NotNull TicketType ticketType) {
        Intrinsics.checkNotNullParameter((Object)ticketType, (String)"ticketType");
        this._ticketTypes.removeIf(arg_0 -> IntercomDataLayer.addTicketType$lambda$2((Function1)new Function1<TicketType, Boolean>(ticketType){
            final /* synthetic */ TicketType $ticketType;
            {
                this.$ticketType = $ticketType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TicketType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getId() == this.$ticketType.getId();
            }
        }, arg_0));
        this._ticketTypes.add(ticketType);
    }

    @Nullable
    public final Conversation getConversationById(@Nullable String id2) {
        Conversation conversation;
        if (id2 == null) {
            conversation = null;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.conversations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Conversation it = (Conversation)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            conversation = v1;
        }
        return conversation;
    }

    /*
     * WARNING - void declaration
     */
    public final void addConversations(@NotNull List<? extends Conversation> newConversations) {
        void $this$distinctBy$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(newConversations, (String)"newConversations");
        Set<Conversation> previousConversations = this._conversations;
        Iterable iterable = CollectionsKt.plus((Collection)newConversations, (Iterable)previousConversations);
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Conversation it = (Conversation)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(ConversationExtensionsKt.lastActionCreatedAt(it));
                it = (Conversation)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(ConversationExtensionsKt.lastActionCreatedAt(it)));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Conversation it = (Conversation)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List updatedList = list$iv;
        this._conversations.clear();
        this._conversations.addAll(updatedList);
    }

    @Nullable
    public final Object emitEvent(@NotNull IntercomEvent intercomEvent, @NotNull Continuation<? super Unit> $completion) {
        Object object = this._event.emit((Object)intercomEvent, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void updateConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (Intrinsics.areEqual((Object)config, (Object)Config.NULL)) {
            return;
        }
        this.updateAppConfig(AppConfigKt.getAppConfig(config, ((AppConfig)this._config.getValue()).getPrimaryColor()));
    }

    public final void resetConfig() {
        AppConfig appConfig = (AppConfig)this.config.getValue();
        NexusConfig nexusConfig = new NexusConfig();
        this.updateAppConfig(AppConfig.copy$default(appConfig, null, 0, 0, 0, 0, false, false, false, false, false, false, false, null, 0, 0L, 0L, 0L, 0L, 0L, false, false, null, null, null, null, false, false, null, null, 0, null, null, null, null, "", false, false, false, false, false, null, null, nexusConfig, false, -1, 3067, null));
    }

    private final void updateAppConfig(AppConfig newAppConfig) {
        if (!Intrinsics.areEqual((Object)newAppConfig, (Object)this._config.getValue())) {
            SharedPreferences prefs = this.context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
            Intrinsics.checkNotNullExpressionValue((Object)prefs, (String)"prefs");
            AppConfigKt.setAppConfig(prefs, newAppConfig);
            this._config.setValue((Object)newAppConfig);
        }
    }

    public final void configUpdates(@NotNull CoroutineScope coroutineScope, @NotNull Function1<? super AppConfig, Unit> onNewAppConfig) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(onNewAppConfig, (String)"onNewAppConfig");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onNewAppConfig, null){
            int label;
            final /* synthetic */ IntercomDataLayer this$0;
            final /* synthetic */ Function1<AppConfig, Unit> $onNewAppConfig;
            {
                this.this$0 = $receiver;
                this.$onNewAppConfig = $onNewAppConfig;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getConfig()), (Function2)((Function2)new Function2<AppConfig, Continuation<? super Unit>, Object>(this.$onNewAppConfig, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Function1<AppConfig, Unit> $onNewAppConfig;
                            {
                                this.$onNewAppConfig = $onNewAppConfig;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AppConfig it = (AppConfig)this.L$0;
                                        this.$onNewAppConfig.invoke((Object)it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                Function2<AppConfig, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value2;
                                return (Continuation)function2;
                            }

                            @Nullable
                            public final Object invoke(@NotNull AppConfig p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void configUpdates$default(IntercomDataLayer intercomDataLayer, CoroutineScope coroutineScope, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
        }
        intercomDataLayer.configUpdates(coroutineScope, (Function1<? super AppConfig, Unit>)function1);
    }

    public final void emitEvent(@NotNull CoroutineScope coroutineScope, @NotNull IntercomEvent event) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ IntercomDataLayer this$0;
            final /* synthetic */ IntercomEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.emitEvent(this.$event, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void listenToEvents(@NotNull CoroutineScope coroutineScope, @NotNull Function1<? super IntercomEvent, Unit> onNewEvent) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(onNewEvent, (String)"onNewEvent");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, onNewEvent, null){
            int label;
            final /* synthetic */ IntercomDataLayer this$0;
            final /* synthetic */ Function1<IntercomEvent, Unit> $onNewEvent;
            {
                this.this$0 = $receiver;
                this.$onNewEvent = $onNewEvent;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getEvent().collect((FlowCollector)new FlowCollector<IntercomEvent>(this.$onNewEvent){
                            final /* synthetic */ Function1<IntercomEvent, Unit> $onNewEvent;
                            {
                                this.$onNewEvent = $onNewEvent;
                            }

                            @Nullable
                            public final Object emit(@NotNull IntercomEvent it, @NotNull Continuation<? super Unit> $completion) {
                                this.$onNewEvent.invoke((Object)it);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final boolean addTicketType$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

