/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.models.carousel.Appearance;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import java.util.List;

public class ContentLayoutManager {
    private final Context context;
    private final BlocksViewHolder blocksViewHolder;

    public ContentLayoutManager(Context context, BlocksViewHolder blocksViewHolder) {
        this.context = context;
        this.blocksViewHolder = blocksViewHolder;
    }

    public void renderCarouselScreen(CarouselScreen carouselScreen, FrameLayout contentContainer) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        LinearLayout rootVerticalLayout = (LinearLayout)inflater.inflate(this.blocksViewHolder.getLayout(), (ViewGroup)contentContainer, false);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)rootVerticalLayout.getLayoutParams();
        params.gravity = carouselScreen.getGravity();
        rootVerticalLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        contentContainer.addView((View)rootVerticalLayout);
        this.renderContent(carouselScreen.getBlocks(), carouselScreen.getTextColor(), rootVerticalLayout);
    }

    @VisibleForTesting
    void renderContent(List<Block> blocks2, String textColor, LinearLayout rootLayout) {
        for (Block block : blocks2) {
            this.renderBlock(block, textColor, rootLayout);
        }
    }

    @VisibleForTesting
    void renderBlock(Block block, String textColor, LinearLayout rootLayout) {
        Appearance.Builder appearanceBuilder = new Appearance.Builder().withTextColor(textColor);
        BlockMetadata blockMetadata = new BlockMetadata.Builder().withAppearance(appearanceBuilder).build();
        View view = block.getType().getView(this.blocksViewHolder, block, (ViewGroup)rootLayout, blockMetadata);
        rootLayout.addView(view);
    }
}

