/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.actions;

import android.app.Activity;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.UsersResponse;

public class Actions {
    private static final Object NONE = "No Value";

    public static Action<BaseResponse> baseResponseReceived(BaseResponse response) {
        return new Action<BaseResponse>(Action.Type.BASE_RESPONSE_RECEIVED, response);
    }

    public static Action<?> softReset() {
        return Actions.noValueAction(Action.Type.SOFT_RESET);
    }

    public static Action<?> hardReset() {
        return Actions.noValueAction(Action.Type.HARD_RESET);
    }

    public static Action<String> conversationMarkedAsRead(String conversationId2) {
        return new Action<String>(Action.Type.CONVERSATION_MARKED_AS_READ, conversationId2);
    }

    public static Action<Conversation> conversationMarkedAsDismissed(Conversation conversation) {
        return new Action<Conversation>(Action.Type.CONVERSATION_MARKED_AS_DISMISSED, conversation);
    }

    public static Action<UsersResponse> unreadConversationsSuccess(UsersResponse response) {
        return new Action<UsersResponse>(Action.Type.UNREAD_CONVERSATIONS_SUCCESS, response);
    }

    public static Action<Conversation> fetchConversationSuccess(Conversation conversation) {
        return new Action<Conversation>(Action.Type.FETCH_CONVERSATION_SUCCESS, conversation);
    }

    public static Action<String> newCommentEventReceived(String conversationId2) {
        return new Action<String>(Action.Type.NEW_COMMENT_EVENT_RECEIVED, conversationId2);
    }

    public static Action<Long> appEnteredForeground(long timestamp) {
        return new Action<Long>(Action.Type.APP_ENTERED_FOREGROUND, timestamp);
    }

    public static Action<Activity> activityReadyForViewAttachment(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_READY_FOR_VIEW_ATTACHMENT, activity);
    }

    public static Action<Activity> activityPaused(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_PAUSED, activity);
    }

    public static Action<Activity> activityStopped(Activity activity) {
        return new Action<Activity>(Action.Type.ACTIVITY_STOPPED, activity);
    }

    public static Action<Long> appEnteredBackground(long timestamp) {
        return new Action<Long>(Action.Type.APP_ENTERED_BACKGROUND, timestamp);
    }

    private static Action<?> noValueAction(Action.Type type2) {
        return new Action<Object>(type2, NONE);
    }
}

