/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.push.IntercomLegacyPushClientHandler;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012J\u001c\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/intercom/android/sdk/push/IntercomPushClient;", "", "twig", "Lcom/intercom/twig/Twig;", "pushHandler", "Lio/intercom/android/sdk/push/IntercomLegacyPushClientHandler;", "<init>", "(Lcom/intercom/twig/Twig;Lio/intercom/android/sdk/push/IntercomLegacyPushClientHandler;)V", "()V", "sendTokenToIntercom", "", "application", "Landroid/app/Application;", "token", "", "handlePush", "message", "Landroid/os/Bundle;", "", "isIntercomPush", "", "convertMessageMapToBundle", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class IntercomPushClient {
    @NotNull
    private final Twig twig;
    @NotNull
    private final IntercomLegacyPushClientHandler pushHandler;
    public static final int $stable = 8;

    public IntercomPushClient(@NotNull Twig twig, @NotNull IntercomLegacyPushClientHandler pushHandler) {
        Intrinsics.checkNotNullParameter((Object)twig, (String)"twig");
        Intrinsics.checkNotNullParameter((Object)pushHandler, (String)"pushHandler");
        this.twig = twig;
        this.pushHandler = pushHandler;
    }

    public IntercomPushClient() {
        Twig twig = LumberMill.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)twig, (String)"getLogger(...)");
        this(twig, new IntercomLegacyPushClientHandler(null, null, 3, null));
    }

    public final void sendTokenToIntercom(@NotNull Application application, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (StringsKt.isBlank((CharSequence)token)) {
            this.twig.e("sendTokenToIntercom() was called with a null or empty token. This user will not receive push notifications until a valid device token is sent.", new Object[0]);
            return;
        }
        Injector.initIfCachedCredentials(application);
        if (Injector.isNotInitialised()) {
            this.twig.w("Token not sent because Intercom is not initialised", new Object[0]);
            return;
        }
        Injector injector = Injector.get();
        if (this.pushHandler.shouldSendDeviceToken((Context)application, token)) {
            Context context = (Context)application;
            Api api = injector.getApi();
            Intrinsics.checkNotNullExpressionValue((Object)api, (String)"getApi(...)");
            UserIdentity userIdentity = injector.getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity, (String)"getUserIdentity(...)");
            Provider<AppConfig> provider = injector.getAppConfigProvider();
            Intrinsics.checkNotNullExpressionValue(provider, (String)"getAppConfigProvider(...)");
            this.pushHandler.sendTokenToIntercom(context, token, api, userIdentity, provider);
        }
    }

    public final void handlePush(@NotNull Application application, @NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.isIntercomPush(message)) {
            this.twig.i("The message passed to handlePush() was not an Intercom push message.", new Object[0]);
            return;
        }
        Injector.initIfCachedCredentials(application);
        if (Injector.isNotInitialised()) {
            this.twig.w("Push not handled because Intercom is not initialised", new Object[0]);
            return;
        }
        Injector injector = Injector.get();
        Provider<AppConfig> appConfigProvider = injector.getAppConfigProvider();
        Context localisedContext = new ContextLocaliser(appConfigProvider).createLocalisedContext((Context)application);
        boolean appBackgrounded = injector.getStore().state().hostAppState().isBackgrounded();
        SystemNotificationManager systemNotificationManager = injector.getSystemNotificationManager();
        Intrinsics.checkNotNull((Object)systemNotificationManager);
        Intrinsics.checkNotNull((Object)localisedContext);
        IntercomLegacyPushClientHandler.Companion.setUpNotificationChannels(systemNotificationManager, localisedContext);
        UserIdentity userIdentity = injector.getUserIdentity();
        Intrinsics.checkNotNullExpressionValue((Object)userIdentity, (String)"getUserIdentity(...)");
        MetricTracker metricTracker = injector.getMetricTracker();
        Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"getMetricTracker(...)");
        AppConfig appConfig = injector.getAppConfigProvider().get();
        Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get(...)");
        this.pushHandler.handlePush(message, userIdentity, systemNotificationManager, appBackgrounded, localisedContext, metricTracker, appConfig);
    }

    public final void handlePush(@NotNull Application application, @NotNull Map<String, String> message) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.handlePush(application, this.convertMessageMapToBundle(message));
    }

    public final boolean isIntercomPush(@NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.pushHandler.isIntercomPush(message);
    }

    public final boolean isIntercomPush(@NotNull Map<String, String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        return this.isIntercomPush(this.convertMessageMapToBundle(message));
    }

    private final Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle(message.size());
        for (Map.Entry<String, String> entry : message.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            bundle.putString(key, value);
        }
        return bundle;
    }
}

