/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils;

import android.content.Context;
import android.content.res.Resources;
import android.media.AudioAttributes;
import android.media.SoundPool;
import androidx.annotation.RawRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u001c\u0010\u0015\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0016\u001a\u00020\u0007H\u0002J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/SoundPlayer;", "", "<init>", "()V", "soundPool", "Landroid/media/SoundPool;", "messageReceivedId", "", "replyFailedId", "replySentId", "operatorReceivedId", "messageReceivedLoaded", "", "replyFailedLoaded", "replySentLoaded", "operatorReceivedLoaded", "loadSounds", "", "context", "Landroid/content/Context;", "release", "loadSound", "soundId", "playMessageFailedSound", "playMessageSentSound", "playAdminMessageReceivedSound", "playOperatorMessageReceivedSound", "playIfLoaded", "loaded", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class SoundPlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SoundPool soundPool;
    private int messageReceivedId;
    private int replyFailedId;
    private int replySentId;
    private int operatorReceivedId;
    private boolean messageReceivedLoaded;
    private boolean replyFailedLoaded;
    private boolean replySentLoaded;
    private boolean operatorReceivedLoaded;
    public static final int $stable = 8;
    private static final Twig TWIG = LumberMill.getLogger();
    public static final int NOT_FOUND_ID = -1;

    public SoundPlayer() {
        SoundPool soundPool = new SoundPool.Builder().setAudioAttributes(new AudioAttributes.Builder().setContentType(4).setUsage(5).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)soundPool, (String)"build(...)");
        this.soundPool = soundPool;
        this.messageReceivedId = -1;
        this.replyFailedId = -1;
        this.replySentId = -1;
        this.operatorReceivedId = -1;
    }

    public final void loadSounds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.soundPool.setOnLoadCompleteListener((arg_0, arg_1, arg_2) -> SoundPlayer.loadSounds$lambda$0(this, arg_0, arg_1, arg_2));
        this.messageReceivedId = this.loadSound(context, R.raw.intercom_received);
        this.replyFailedId = this.loadSound(context, R.raw.intercom_failed);
        this.replySentId = this.loadSound(context, R.raw.intercom_sent);
        this.operatorReceivedId = this.loadSound(context, R.raw.intercom_operator);
    }

    public final void release() {
        this.soundPool.release();
    }

    private final int loadSound(Context context, @RawRes int soundId) {
        int n;
        try {
            n = this.soundPool.load(context, soundId, 1);
        }
        catch (Resources.NotFoundException e) {
            TWIG.e((Throwable)e, "Could not play sound", new Object[0]);
            n = -1;
        }
        return n;
    }

    public final void playMessageFailedSound() {
        this.playIfLoaded(this.replyFailedLoaded, this.replyFailedId);
    }

    public final void playMessageSentSound() {
        this.playIfLoaded(this.replySentLoaded, this.replySentId);
    }

    public final void playAdminMessageReceivedSound() {
        this.playIfLoaded(this.messageReceivedLoaded, this.messageReceivedId);
    }

    public final void playOperatorMessageReceivedSound() {
        this.playIfLoaded(this.operatorReceivedLoaded, this.operatorReceivedId);
    }

    private final void playIfLoaded(boolean loaded, int soundId) {
        if (loaded && soundId != -1) {
            this.soundPool.play(soundId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }

    private static final void loadSounds$lambda$0(SoundPlayer this$0, SoundPool soundPool, int sampleId, int status) {
        if (status == 0) {
            int n = sampleId;
            if (n == this$0.messageReceivedId) {
                this$0.messageReceivedLoaded = true;
            } else if (n == this$0.replyFailedId) {
                this$0.replyFailedLoaded = true;
            } else if (n == this$0.replySentId) {
                this$0.replySentLoaded = true;
            } else if (n == this$0.operatorReceivedId) {
                this$0.operatorReceivedLoaded = true;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/intercom/android/sdk/m5/conversation/utils/SoundPlayer$Companion;", "", "<init>", "()V", "TWIG", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "NOT_FOUND_ID", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

