/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.nexus.NexusEventType;
import io.intercom.android.nexus.NexusListener;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0007J\u000f\u0010 \u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/intercom/android/sdk/NexusWrapper;", "Lio/intercom/android/nexus/NexusClient;", "Lio/intercom/android/nexus/NexusListener;", "twig", "Lcom/intercom/twig/Twig;", "okHttpClient", "Lokhttp3/OkHttpClient;", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "api", "Lio/intercom/android/sdk/api/Api;", "debouncePeriodMs", "", "dataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "<init>", "(Lcom/intercom/twig/Twig;Lokhttp3/OkHttpClient;Lio/intercom/android/sdk/store/Store;Lio/intercom/android/sdk/api/Api;JLio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "actionFuture", "Ljava/util/concurrent/ScheduledFuture;", "connect", "", "config", "Lio/intercom/android/nexus/NexusConfig;", "shouldSendPresence", "", "connectNow", "disconnect", "disconnectNow", "removeCallbacks", "()Ljava/lang/Boolean;", "notifyEvent", "event", "Lio/intercom/android/nexus/NexusEvent;", "logKnownEvent", "onConnect", "onConnectFailed", "onShutdown", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class NexusWrapper
extends NexusClient
implements NexusListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Twig twig;
    @NotNull
    private final Store<State> store;
    @NotNull
    private final Api api;
    private final long debouncePeriodMs;
    @NotNull
    private final IntercomDataLayer dataLayer;
    private final ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<?> actionFuture;
    public static final int $stable = 8;
    @NotNull
    private static final String CONVERSATION_ID = "conversationId";

    public NexusWrapper(@NotNull Twig twig, @NotNull OkHttpClient okHttpClient, @NotNull Store<State> store, @NotNull Api api, long debouncePeriodMs, @NotNull IntercomDataLayer dataLayer) {
        Intrinsics.checkNotNullParameter((Object)twig, (String)"twig");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)dataLayer, (String)"dataLayer");
        super(twig, okHttpClient);
        this.twig = twig;
        this.store = store;
        this.api = api;
        this.debouncePeriodMs = debouncePeriodMs;
        this.dataLayer = dataLayer;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void connect(@NotNull NexusConfig config, boolean shouldSendPresence) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getEndpoints().isEmpty()) {
            this.twig.w("No realtime endpoints present so we can't connect", new Object[0]);
            return;
        }
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(() -> NexusWrapper.connect$lambda$0(this, config, shouldSendPresence), this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public final void connectNow(@NotNull NexusConfig config, boolean shouldSendPresence) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.isConnected()) {
            return;
        }
        super.connect(config, shouldSendPresence);
        this.setTopics(CollectionsKt.listOf((Object)"*"));
        this.addEventListener(this);
    }

    public void disconnect() {
        this.removeCallbacks();
        this.actionFuture = this.executor.schedule(() -> NexusWrapper.disconnect$lambda$1(this), this.debouncePeriodMs, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public final void disconnectNow() {
        this.removeEventListener(this);
        super.disconnect();
    }

    private final Boolean removeCallbacks() {
        ScheduledFuture<?> scheduledFuture = this.actionFuture;
        return scheduledFuture != null ? Boolean.valueOf(scheduledFuture.cancel(false)) : null;
    }

    public void notifyEvent(@NotNull NexusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String conversationId2 = event.getEventData().optString(CONVERSATION_ID);
        NexusEventType nexusEventType = event.getEventType();
        switch (nexusEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nexusEventType.ordinal()]) {
            case 1: {
                this.logKnownEvent(event);
                break;
            }
            case 2: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.newCommentEventReceived(conversationId2));
                break;
            }
            case 3: {
                this.logKnownEvent(event);
                break;
            }
            case 4: {
                this.logKnownEvent(event);
                this.store.dispatch(Actions.conversationMarkedAsRead(conversationId2));
                Intrinsics.checkNotNull((Object)conversationId2);
                this.dataLayer.markConversationAsRead(conversationId2);
                break;
            }
            case 5: {
                this.logKnownEvent(event);
                long entityType = event.getEventData().optLong("entity_type");
                String entityId = event.getEventData().optString("entity_id");
                long l = entityType;
                if (l == 44L) {
                    this.api.fetchCarouselByEntityId(entityId);
                    break;
                }
                if (l == 85L) {
                    this.api.fetchSurveyByEntityId(entityId);
                    break;
                }
                this.twig.internal("Nexus NewContent", "Unexpected entity type: " + entityType);
                break;
            }
            default: {
                this.twig.internal("Nexus", "Unexpected event: " + event.getEventType());
            }
        }
    }

    private final void logKnownEvent(NexusEvent event) {
        this.twig.internal("Nexus", "Received " + event.getEventType() + " event");
    }

    public void onConnect() {
    }

    public void onConnectFailed() {
    }

    public void onShutdown() {
    }

    private static final void connect$lambda$0(NexusWrapper this$0, NexusConfig $config, boolean $shouldSendPresence) {
        this$0.connectNow($config, $shouldSendPresence);
    }

    private static final void disconnect$lambda$1(NexusWrapper this$0) {
        this$0.disconnectNow();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/NexusWrapper$Companion;", "", "<init>", "()V", "CONVERSATION_ID", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NexusEventType.values().length];
            try {
                nArray[NexusEventType.AdminIsTyping.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.NewComment.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.UserContentSeenByAdmin.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.ConversationSeen.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NexusEventType.NewContent.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

