/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.extensions;

import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001a\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0012"}, d2={"shouldConcatenate", "", "part", "Lio/intercom/android/sdk/models/Part;", "nextPart", "hasNextConcatPart", "", "index", "", "hasPreviousConcatPart", "isAttributeCollector", "isLinkCard", "isQuickReplyOnly", "isSingleBlockPartOfType", "type", "Lio/intercom/android/sdk/blocks/lib/BlockType;", "isTypingPart", "nextPartFromSameParticipant", "intercom-sdk-base_release"})
public final class PartExtensionsKt {
    public static final boolean nextPartFromSameParticipant(@NotNull Part $this$nextPartFromSameParticipant, @NotNull Part nextPart) {
        Intrinsics.checkNotNullParameter((Object)$this$nextPartFromSameParticipant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        return Intrinsics.areEqual((Object)$this$nextPartFromSameParticipant.getParticipantId(), (Object)nextPart.getParticipantId());
    }

    public static final boolean isTypingPart(@NotNull Part $this$isTypingPart) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypingPart, (String)"<this>");
        return $this$isTypingPart.getMessageStyle() == MessageStyle.ADMIN_IS_TYPING_STYLE;
    }

    public static final boolean isAttributeCollector(@NotNull Part $this$isAttributeCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$isAttributeCollector, (String)"<this>");
        return $this$isAttributeCollector.getMessageStyle() == MessageStyle.ATTRIBUTE_COLLECTOR && !((Collection)$this$isAttributeCollector.getForm().getAttributes()).isEmpty();
    }

    public static final boolean isLinkCard(@NotNull Part $this$isLinkCard) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkCard, (String)"<this>");
        return PartExtensionsKt.isSingleBlockPartOfType($this$isLinkCard, BlockType.LINK) && MessageStyle.CHAT == $this$isLinkCard.getMessageStyle();
    }

    public static final boolean isQuickReplyOnly(@NotNull Part $this$isQuickReplyOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuickReplyOnly, (String)"<this>");
        List<ReplyOption> list = $this$isQuickReplyOnly.getReplyOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReplyOptions(...)");
        return !((Collection)list).isEmpty() && $this$isQuickReplyOnly.getBlocks().isEmpty();
    }

    public static final boolean hasPreviousConcatPart(@NotNull List<? extends Part> $this$hasPreviousConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPart, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasPreviousConcatPart.get(index - 1), $this$hasPreviousConcatPart.get(index));
    }

    public static final boolean hasNextConcatPart(@NotNull List<? extends Part> $this$hasNextConcatPart, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPart, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPart) : false) && PartExtensionsKt.shouldConcatenate($this$hasNextConcatPart.get(index), $this$hasNextConcatPart.get(index + 1));
    }

    private static final boolean isSingleBlockPartOfType(Part $this$isSingleBlockPartOfType, BlockType type) {
        return $this$isSingleBlockPartOfType.getBlocks().size() == 1 && $this$isSingleBlockPartOfType.getBlocks().get(0).getType() == type;
    }

    private static final boolean shouldConcatenate(Part part, Part nextPart) {
        return PartExtensionsKt.nextPartFromSameParticipant(part, nextPart) && Math.abs(nextPart.getCreatedAt() - part.getCreatedAt()) < TimeUnit.MINUTES.toSeconds(3L) && !PartExtensionsKt.isTypingPart(part) && !PartExtensionsKt.isTypingPart(nextPart) && !PartExtensionsKt.isLinkCard(part) && !PartExtensionsKt.isLinkCard(nextPart) && part.isEvent() == false && nextPart.isEvent() == false && !PartExtensionsKt.isAttributeCollector(part) && !PartExtensionsKt.isAttributeCollector(nextPart) && !PartExtensionsKt.isQuickReplyOnly(part) && !PartExtensionsKt.isQuickReplyOnly(nextPart);
    }
}

