/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AlertDialog;
import com.google.gson.Gson;
import io.intercom.android.sdk.activities.IntercomSheetActivity;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardAlertDialogBuilder;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewAction;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.m5.navigation.IntercomRootActivityLauncher;
import io.intercom.android.sdk.metrics.MetricTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class MessengerCardWebViewInterface {
    private static final String OPEN_URL = "OPEN_URL";
    private static final String OPEN_SHEET = "OPEN_SHEET";
    private static final String INPUT_TEXT = "INPUT_TEXT";
    private static final String METRIC_EVENT = "METRIC_EVENT";
    private static final String HEIGHT_CHANGE_EVENT = "HEIGHT_CHANGE_EVENT";
    private static final Double MESSENGER_APP_ID_ARTICLE_SEARCH = 27.0;
    private final WebView webView;
    private final View loadingView;
    private final Gson gson;
    private final int primaryColor;
    private final MetricTracker metricTracker;
    private final String conversationId;
    private final Boolean isHomescreen;
    private final Context context;

    MessengerCardWebViewInterface(WebView webView, View loadingView, Gson gson, @ColorInt int primaryColor, MetricTracker metricTracker, String conversationId2, boolean isHomescreen, Context context) {
        this.webView = webView;
        this.loadingView = loadingView;
        this.gson = gson;
        this.primaryColor = primaryColor;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId2;
        this.isHomescreen = isHomescreen;
        this.context = context;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        final MessengerCardWebViewAction action = (MessengerCardWebViewAction)this.gson.fromJson(actionJson, MessengerCardWebViewAction.class);
        final Map<String, Object> payload = action.getPayload();
        String type = action.getType();
        if (type == null || payload == null) {
            return;
        }
        switch (type) {
            case "OPEN_URL": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.openUrl(payload, MessengerCardWebViewInterface.this.context);
                    }
                });
                break;
            }
            case "OPEN_SHEET": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.openSheet(payload, MessengerCardWebViewInterface.this.context);
                    }
                });
                break;
            }
            case "INPUT_TEXT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        Double messengerAppId = (Double)payload.get("messengerAppId");
                        if (MESSENGER_APP_ID_ARTICLE_SEARCH.equals(messengerAppId)) {
                            IntercomRootActivityLauncher.INSTANCE.startHelpCenterCollections(MessengerCardWebViewInterface.this.webView.getContext(), Collections.emptyList(), "legacy_article_search_app");
                        } else {
                            MessengerCardWebViewInterface.this.showTextInputDialog(payload, MessengerCardWebViewInterface.this.context);
                        }
                    }
                });
                break;
            }
            case "HEIGHT_CHANGE_EVENT": {
                if (this.loadingView.getVisibility() != 0) break;
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        MessengerCardWebViewInterface.this.loadingView.setVisibility(8);
                        MessengerCardWebViewInterface.this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
                    }
                });
                break;
            }
            case "METRIC_EVENT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, Object> actionValue = action.getPayload();
                        String eventAction = (String)actionValue.get("action");
                        String eventObject = (String)actionValue.get("object");
                        String eventPlace = (String)actionValue.get("place");
                        Map eventMetaData = null;
                        if (actionValue.get("metadata") instanceof Map) {
                            eventMetaData = (Map)actionValue.get("metadata");
                        }
                        MessengerCardWebViewInterface.this.metricTracker.messengerCardWebViewEvent(eventAction, eventObject, eventPlace, eventMetaData, MessengerCardWebViewInterface.this.isHomescreen);
                    }
                });
                break;
            }
        }
    }

    private void openUrl(Map<String, Object> payload, Context context) {
        String url = (String)payload.get("url");
        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
    }

    private void openSheet(Map<String, Object> payload, Context context) {
        Map values;
        String articleId;
        String url = (String)payload.get("url");
        HashMap<String, Object> params = payload.containsKey("params") ? (Map)payload.get("params") : new HashMap();
        String cardUri = this.getStringFromMap(params, "uri");
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)cardUri)) {
            return;
        }
        String actionId = this.getStringFromMap(params, "action_id");
        if ("article-link".equals(actionId) && params.containsKey("values") && !TextUtils.isEmpty((CharSequence)(articleId = this.getStringFromMap(values = (Map)params.get("values"), "article_id")))) {
            this.displayArticle(articleId, context);
            return;
        }
        Intent intent = IntercomSheetActivity.buildIntent(context, url, params, cardUri, this.conversationId);
        context.startActivity(intent);
    }

    private String getStringFromMap(Map<String, Object> map2, String key) {
        return map2.containsKey(key) ? String.valueOf(map2.get(key)) : "";
    }

    private void displayArticle(String articleId, Context context) {
        String metricPlace = this.isHomescreen != false ? "messenger_home_app" : "conversation";
        Intent intent = ArticleActivity.buildIntent(context, new ArticleActivity.ArticleActivityArguments(articleId, metricPlace));
        context.startActivity(intent);
    }

    private void showTextInputDialog(Map<String, Object> payload, Context context) {
        MessengerCardAlertDialogBuilder dialogBuilder = new MessengerCardAlertDialogBuilder(context, payload, this.primaryColor, this.webView);
        AlertDialog dialog = dialogBuilder.create();
        dialog.show();
        dialog.getWindow().setSoftInputMode(5);
        dialog.getButton(-2).setTextColor(this.primaryColor);
        dialog.getButton(-1).setTextColor(this.primaryColor);
    }
}

