/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets.list.ui;

import androidx.annotation.DrawableRes;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.tickets.TicketStatus;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000eH\u00d6\u0001R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/intercom/android/sdk/tickets/list/ui/TicketRowData;", "", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "(Lio/intercom/android/sdk/models/Ticket;)V", "iconResId", "", "getIconResId", "()I", "status", "Lio/intercom/android/sdk/tickets/TicketStatus;", "getStatus", "()Lio/intercom/android/sdk/tickets/TicketStatus;", "statusText", "", "getStatusText", "()Ljava/lang/String;", "getTicket", "()Lio/intercom/android/sdk/models/Ticket;", "title", "getTitle", "component1", "copy", "equals", "", "other", "hashCode", "toString", "intercom-sdk-base_release"})
public final class TicketRowData {
    @NotNull
    private final Ticket ticket;
    @NotNull
    private final String title;
    @NotNull
    private final TicketStatus status;
    @NotNull
    private final String statusText;
    @DrawableRes
    private final int iconResId;

    public TicketRowData(@NotNull Ticket ticket) {
        int n;
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        this.ticket = ticket;
        this.title = this.ticket.getTitle();
        this.status = TicketDetailReducerKt.toTicketStatus(this.ticket.getCurrentStatus());
        this.statusText = this.ticket.getCurrentStatus().getTitle();
        switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
            case 1: 
            case 2: {
                n = R.drawable.intercom_ticket_submitted_icon;
                break;
            }
            case 3: {
                n = R.drawable.intercom_ticket_waiting_icon;
                break;
            }
            case 4: {
                n = R.drawable.intercom_ticket_resolved_icon;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.iconResId = n;
    }

    @NotNull
    public final Ticket getTicket() {
        return this.ticket;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final TicketStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final String getStatusText() {
        return this.statusText;
    }

    public final int getIconResId() {
        return this.iconResId;
    }

    @NotNull
    public final Ticket component1() {
        return this.ticket;
    }

    @NotNull
    public final TicketRowData copy(@NotNull Ticket ticket) {
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        return new TicketRowData(ticket);
    }

    public static /* synthetic */ TicketRowData copy$default(TicketRowData ticketRowData, Ticket ticket, int n, Object object) {
        if ((n & 1) != 0) {
            ticket = ticketRowData.ticket;
        }
        return ticketRowData.copy(ticket);
    }

    @NotNull
    public String toString() {
        return "TicketRowData(ticket=" + this.ticket + ')';
    }

    public int hashCode() {
        return this.ticket.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TicketRowData)) {
            return false;
        }
        TicketRowData ticketRowData = (TicketRowData)other;
        return Intrinsics.areEqual((Object)this.ticket, (Object)ticketRowData.ticket);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TicketStatus.values().length];
            try {
                nArray[TicketStatus.Submitted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TicketStatus.InProgress.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TicketStatus.WaitingOnCustomer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TicketStatus.Resolved.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

