/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputDataSource;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.conversation.composer.galleryinput.Debouncer;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.GifResponse;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class GifInputDataSource
implements GalleryInputDataSource {
    private static final long DEBOUNCE_DELAY_MS = 300L;
    private final Api api;
    private final Debouncer debouncer = new Debouncer();
    private final MetricTracker metricTracker;
    private GalleryInputDataSource.Listener listener;
    private boolean loading;
    private int currentCount = 0;
    @Nullable
    private String lastQuery;

    GifInputDataSource(Api api, MetricTracker metricTracker) {
        this.api = api;
        this.metricTracker = metricTracker;
    }

    public int getPermissionStatus() {
        return 0;
    }

    public void requestPermission() {
    }

    public void setListener(GalleryInputDataSource.Listener listener2) {
        this.listener = listener2;
    }

    public void getImages(int offset, @Nullable String query) {
        this.loading = true;
        this.lastQuery = query;
        if (TextUtils.isEmpty((CharSequence)query)) {
            this.loadDefaultGifs();
        } else {
            this.searchGifs(query);
        }
    }

    private void loadDefaultGifs() {
        this.api.fetchDefaultGifs(new Callback<GifResponse>(){

            public void onResponse(Call<GifResponse> call, Response<GifResponse> response) {
                GifInputDataSource.this.loading = false;
                GifInputDataSource.this.handleGifResponse((Response<GifResponse>)response);
            }

            public void onFailure(Call<GifResponse> call, Throwable t) {
                GifInputDataSource.this.loading = false;
                GifInputDataSource.this.listener.onError();
            }
        });
    }

    private void searchGifs(final String query) {
        this.metricTracker.searchedGifInput(query);
        this.debouncer.call(new Runnable(){

            @Override
            public void run() {
                GifInputDataSource.this.api.fetchGifs(query, new Callback<GifResponse>(){

                    public void onResponse(Call<GifResponse> call, Response<GifResponse> response) {
                        GifInputDataSource.this.loading = false;
                        if (!query.equals(GifInputDataSource.this.lastQuery)) {
                            return;
                        }
                        GifInputDataSource.this.handleGifResponse((Response<GifResponse>)response);
                    }

                    public void onFailure(Call<GifResponse> call, Throwable t) {
                        GifInputDataSource.this.loading = false;
                        GifInputDataSource.this.listener.onError();
                    }
                });
            }
        }, 300L);
    }

    private void handleGifResponse(Response<GifResponse> response) {
        GifResponse responseBody = (GifResponse)response.body();
        if (responseBody != null) {
            List<GalleryImage> images = this.getImagesFromResponse(responseBody.results());
            this.listener.onSuccess(images);
        } else {
            this.listener.onError();
        }
    }

    @VisibleForTesting
    List<GalleryImage> getImagesFromResponse(List<Block> results) {
        this.currentCount = results.size();
        ArrayList<GalleryImage> images = new ArrayList<GalleryImage>(this.currentCount);
        for (Block result2 : results) {
            GalleryImage galleryImage = new GalleryImage("", "", Uri.parse((String)result2.getUrl()), result2.getPreviewUrl(), result2.getAttribution(), result2.getWidth(), result2.getHeight(), 0, true, false, "");
            images.add(galleryImage);
        }
        return images;
    }

    public int getCount() {
        return this.currentCount;
    }

    public boolean isLoading() {
        return this.loading;
    }
}

