/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.content.pm.ShortcutInfoCompat;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomPushBitmapUtilsKt;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.m5.push.NotificationChannel;
import io.intercom.android.sdk.m5.push.NotificationPermissionCheckerKt;
import io.intercom.android.sdk.m5.push.ui.ConversationShortcutKt;
import io.intercom.android.sdk.m5.push.ui.ConversationStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.DeepLinkStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.IntercomPushConversation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00052\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001d\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ,\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomNotificationHandler;", "", "()V", "conversations", "", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation;", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "clear", "", "context", "Landroid/content/Context;", "getOrCreateConversation", "conversationPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$ConversationPushData;", "avatarBitmap", "Landroid/graphics/Bitmap;", "processConversationPushNotification", "processConversationPushNotification$intercom_sdk_base_release", "processDeepLinkPushNotification", "deepLinkPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$DeepLinkPushData;", "processIntercomPushNotification", "intercomPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData;", "processIntercomPushNotification$intercom_sdk_base_release", "setUpNotificationChannels", "setUpNotificationChannels$intercom_sdk_base_release", "updateConversations", "Lkotlin/Pair;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nIntercomNotificationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomNotificationHandler.kt\nio/intercom/android/sdk/m5/push/IntercomNotificationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
public final class IntercomNotificationHandler {
    @NotNull
    public static final IntercomNotificationHandler INSTANCE = new IntercomNotificationHandler();
    @NotNull
    private static List<IntercomPushConversation> conversations = CollectionsKt.emptyList();
    private static final Twig twig = LumberMill.getLogger();

    private IntercomNotificationHandler() {
    }

    public final void processIntercomPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData intercomPushData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intercomPushData, (String)"intercomPushData");
        IntercomPushData intercomPushData2 = intercomPushData;
        if (intercomPushData2 instanceof IntercomPushData.DeepLinkPushData) {
            this.processDeepLinkPushNotification(context, (IntercomPushData.DeepLinkPushData)intercomPushData);
        } else if (intercomPushData2 instanceof IntercomPushData.ConversationPushData) {
            this.processConversationPushNotification$intercom_sdk_base_release(context, (IntercomPushData.ConversationPushData)intercomPushData);
        }
    }

    private final void processDeepLinkPushNotification(Context context, IntercomPushData.DeepLinkPushData deepLinkPushData) {
        twig.i("This is a push only message", new Object[0]);
        IntercomPushBitmapUtilsKt.loadContentBitmap(context, deepLinkPushData.getContentImageUrl(), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(context, deepLinkPushData){
            final /* synthetic */ Context $context;
            final /* synthetic */ IntercomPushData.DeepLinkPushData $deepLinkPushData;
            {
                this.$context = $context;
                this.$deepLinkPushData = $deepLinkPushData;
                super(1);
            }

            public final void invoke(@Nullable Bitmap contentBitmap) {
                Notification notification = DeepLinkStylePushUIKt.buildDeepLinkNotification(this.$context, this.$deepLinkPushData, contentBitmap);
                NotificationPermissionCheckerKt.showNotification(this.$context, this.$deepLinkPushData.getNotificationId(), notification);
            }
        }));
    }

    public final void processConversationPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData.ConversationPushData conversationPushData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversationPushData, (String)"conversationPushData");
        if (Injector.get().getStore().state().hostAppState().isBackgrounded()) {
            twig.i("This is a background push message", new Object[0]);
            IntercomPushBitmapUtilsKt.loadAvatarBitmap(context, conversationPushData.getAvatarUrl(), conversationPushData.getAuthorName(), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(conversationPushData, context){
                final /* synthetic */ IntercomPushData.ConversationPushData $conversationPushData;
                final /* synthetic */ Context $context;
                {
                    this.$conversationPushData = $conversationPushData;
                    this.$context = $context;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@Nullable Bitmap avatarBitmap) {
                    void $this$invoke_u24lambda_u241;
                    Map map2;
                    Pair pair = IntercomNotificationHandler.access$updateConversations(IntercomNotificationHandler.INSTANCE, this.$conversationPushData, avatarBitmap);
                    IntercomPushConversation conversation = (IntercomPushConversation)pair.component1();
                    List conversations = (List)pair.component2();
                    Pair<List<ShortcutInfoCompat>, ShortcutInfoCompat> pair2 = ConversationShortcutKt.createTemporaryShortcut(this.$context, conversation.getConversationId(), conversation.getConversationTitle());
                    List dynamicShortcuts = (List)pair2.component1();
                    ShortcutInfoCompat temporaryShortcut = (ShortcutInfoCompat)pair2.component2();
                    NotificationChannel notificationChannel = this.$conversationPushData.isNewConversation() ? NotificationChannel.NEW_CHATS_CHANNEL : NotificationChannel.CHAT_REPLIES_CHANNEL;
                    Notification conversationNotification = ConversationStylePushUIKt.buildConversationStyleNotification(this.$context, conversation, temporaryShortcut, notificationChannel);
                    Notification summaryNotification = conversations.size() > 1 ? ConversationStylePushUIKt.buildConversationStyleSummaryNotification(this.$context, conversations, notificationChannel) : null;
                    IntercomPushData.ConversationPushData conversationPushData = this.$conversationPushData;
                    Map map3 = map2 = MapsKt.createMapBuilder();
                    Context context = this.$context;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.put(conversationPushData.getNotificationId(), conversationNotification);
                    Notification notification = summaryNotification;
                    if (notification != null) {
                        Notification it = notification;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241.put(9999997, it);
                    }
                    NotificationPermissionCheckerKt.showNotifications(context, MapsKt.build((Map)map2));
                    ConversationShortcutKt.resetShortcuts(this.$context, dynamicShortcuts);
                }
            }));
        } else {
            twig.i("Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.", new Object[0]);
        }
    }

    public final synchronized void clear(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!((Collection)conversations).isEmpty()) {
            twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        NotificationManagerCompat $this$clear_u24lambda_u240 = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        $this$clear_u24lambda_u240.cancelAll();
        conversations = CollectionsKt.emptyList();
    }

    private final synchronized Pair<IntercomPushConversation, List<IntercomPushConversation>> updateConversations(IntercomPushData.ConversationPushData conversationPushData, Bitmap avatarBitmap) {
        IntercomPushConversation conversation = this.getOrCreateConversation(conversations, conversationPushData, avatarBitmap);
        List updatedConversations = CollectionsKt.toMutableList((Collection)conversations);
        CollectionsKt.removeAll((List)updatedConversations, (Function1)((Function1)new Function1<IntercomPushConversation, Boolean>(conversation){
            final /* synthetic */ IntercomPushConversation $conversation;
            {
                this.$conversation = $conversation;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IntercomPushConversation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getConversationId(), (Object)this.$conversation.getConversationId());
            }
        }));
        updatedConversations.add(conversation);
        conversations = updatedConversations;
        return TuplesKt.to((Object)conversation, (Object)updatedConversations);
    }

    private final IntercomPushConversation getOrCreateConversation(List<IntercomPushConversation> conversations, IntercomPushData.ConversationPushData conversationPushData, Bitmap avatarBitmap) {
        List list;
        Object v0;
        block4: {
            Iterable iterable = conversations;
            for (Object t : iterable) {
                IntercomPushConversation it = (IntercomPushConversation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConversationId(), (Object)conversationPushData.getConversationId())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        IntercomPushConversation intercomPushConversation = v0;
        if (intercomPushConversation == null) {
            return new IntercomPushConversation(conversationPushData.getConversationId(), conversationPushData.getAuthorName(), CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage$default(conversationPushData, avatarBitmap, 0L, 2, null)));
        }
        IntercomPushConversation conversation = intercomPushConversation;
        IntercomPushConversation.Message message = (IntercomPushConversation.Message)CollectionsKt.lastOrNull(conversation.getMessages());
        boolean bl = message != null ? message.isCurrentUser() : false;
        if (bl && !conversationPushData.isCurrentUser()) {
            list = CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage$default(conversationPushData, avatarBitmap, 0L, 2, null));
        } else {
            List list2;
            List $this$getOrCreateConversation_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$getOrCreateConversation_u24lambda_u242.addAll((Collection)conversation.getMessages());
            $this$getOrCreateConversation_u24lambda_u242.add(ConversationStylePushUIKt.toMessage$default(conversationPushData, avatarBitmap, 0L, 2, null));
            list = CollectionsKt.build((List)list2);
        }
        List messages = list;
        return IntercomPushConversation.copy$default(conversation, null, null, messages, 3, null);
    }

    public final void setUpNotificationChannels$intercom_sdk_base_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NotificationChannelCompat notificationChannelCompat = new NotificationChannelCompat.Builder(NotificationChannel.CHAT_REPLIES_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_chat_replies_title)).setDescription(context.getString(R.string.intercom_notification_channel_chat_replies_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat, (String)"Builder(CHAT_REPLIES_CHA\u2026\n                .build()");
        NotificationChannelCompat replies = notificationChannelCompat;
        NotificationChannelCompat notificationChannelCompat2 = new NotificationChannelCompat.Builder(NotificationChannel.NEW_CHATS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_new_chats_title)).setDescription(context.getString(R.string.intercom_notification_channel_new_chats_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat2, (String)"Builder(NEW_CHATS_CHANNE\u2026\n                .build()");
        NotificationChannelCompat newChats = notificationChannelCompat2;
        NotificationChannelCompat notificationChannelCompat3 = new NotificationChannelCompat.Builder(NotificationChannel.ACTIONS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_actions_title)).setDescription(context.getString(R.string.intercom_notification_channel_actions_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat3, (String)"Builder(ACTIONS_CHANNEL.\u2026\n                .build()");
        NotificationChannelCompat actions = notificationChannelCompat3;
        NotificationManagerCompat $this$setUpNotificationChannels_u24lambda_u243 = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        Object[] objectArray = new NotificationChannelCompat[]{replies, newChats, actions};
        $this$setUpNotificationChannels_u24lambda_u243.createNotificationChannelsCompat(CollectionsKt.listOf((Object[])objectArray));
    }

    public static final /* synthetic */ Pair access$updateConversations(IntercomNotificationHandler $this, IntercomPushData.ConversationPushData conversationPushData, Bitmap avatarBitmap) {
        return $this.updateConversations(conversationPushData, avatarBitmap);
    }
}

