/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.ActiveConversationState;
import io.intercom.android.sdk.store.Store;

public class ActiveConversationStateReducer
implements Store.Reducer<ActiveConversationState> {
    public static final ActiveConversationState INITIAL_STATE = ActiveConversationState.create("", false, false, "");

    @Override
    public ActiveConversationState reduce(Action<?> action, ActiveConversationState currentState) {
        switch (action.type()) {
            case COMPOSER_TYPED_IN: {
                return ActiveConversationState.create(currentState.getConversationId(), currentState.hasSwitchedInputType(), true, "");
            }
            case COMPOSER_CLEARED: {
                return ActiveConversationState.create(currentState.getConversationId(), currentState.hasSwitchedInputType(), false, "");
            }
            case COMPOSER_INPUT_CHANGED: {
                return ActiveConversationState.create(currentState.getConversationId(), true, currentState.hasTextInComposer(), "");
            }
            case COMPOSER_SEND_BUTTON_PRESSED: {
                return ActiveConversationState.create(currentState.getConversationId(), INITIAL_STATE.hasSwitchedInputType(), INITIAL_STATE.hasTextInComposer(), "");
            }
            case FETCH_CONVERSATION_SUCCESS: 
            case NEW_CONVERSATION_SUCCESS: {
                Conversation conversation = (Conversation)action.value();
                return ActiveConversationState.create(conversation.getId(), currentState.hasSwitchedInputType(), currentState.hasTextInComposer(), "");
            }
            case COMPOSER_SUGGESTION_SELECTED: {
                String uuid = String.valueOf(action.value());
                return ActiveConversationState.create(currentState.getConversationId(), currentState.hasSwitchedInputType(), currentState.hasTextInComposer(), uuid);
            }
            case CONVERSATION_OPENED: {
                return ActiveConversationState.create((String)action.value(), currentState.hasSwitchedInputType(), currentState.hasTextInComposer(), "");
            }
            case CONVERSATION_CLOSED: {
                return INITIAL_STATE;
            }
        }
        return currentState;
    }
}

