/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.models.AutoValue_Config;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@AutoValue
public abstract class Config {
    public static final int DEFAULT_RATE_LIMIT_COUNT = 100;
    public static final long DEFAULT_RATE_LIMIT_PERIOD_MS = TimeUnit.MINUTES.toMillis(1L);
    public static final long DEFAULT_CACHE_MAX_AGE_MS = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_SESSION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(20L);
    public static final long DEFAULT_SOFT_RESET_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFAULT_UPLOAD_SIZE_LIMIT = 0x2800000L;
    public static final Config NULL = new Builder().build();

    public abstract String getName();

    @Nullable
    public abstract String getPrimaryColor();

    @Nullable
    public abstract String getSecondaryColor();

    public abstract String getWelcomeMessage();

    public abstract String getMessengerBackground();

    public abstract String getMessenger4Background();

    public abstract String getLocale();

    public abstract String getHelpCenterLocale();

    public abstract String getLauncherLogoUrl();

    public abstract String getMessengerLogoUrl();

    public abstract String getTeamIntro();

    public abstract String getTeamGreeting();

    public abstract boolean isFirstRequest();

    public abstract boolean isInboundMessages();

    public abstract boolean isAttachmentsEnabled();

    public abstract boolean isGifsEnabled();

    public abstract String temporaryExpectationsMessage();

    public abstract boolean isShowPoweredBy();

    public abstract boolean isAudioEnabled();

    public abstract boolean isMetricsEnabled();

    public abstract boolean isBackgroundRequestsEnabled();

    public abstract boolean isPrimaryColorRenderDarkText();

    public abstract boolean isSecondaryColorRenderDarkText();

    public abstract boolean isHelpCenterColorRenderDarkText();

    public abstract long getRateLimitPeriod();

    public abstract int getRateLimitCount();

    public abstract long getUserUpdateCacheMaxAge();

    public abstract long getSoftResetTimeout();

    public abstract long getNewSessionThreshold();

    public abstract long getUploadSizeLimit();

    public abstract NexusConfig getRealTimeConfig();

    public abstract String getHelpCenterUrl();

    public abstract Set<String> getHelpCenterUrls();

    @Nullable
    public abstract String getHelpCenterBaseColor();

    public abstract Set<String> getFeatures();

    public abstract boolean getIdentityVerificationEnabled();

    public abstract boolean accessToTeammateEnabled();

    public abstract boolean helpCenterRequireSearch();

    public abstract boolean preventMultipleInboundConversationsEnabled();

    public abstract boolean hasOpenConversations();

    public abstract ConfigModules modules();

    public abstract Set<String> getFileUploadSupportedFileTypes();

    public abstract boolean isNewConversationScreenDisabled();

    public static final class Builder {
        @Nullable
        String name;
        @Nullable
        String base_color;
        @Nullable
        String secondary_color;
        @Nullable
        String welcome_message_plain_text;
        @Nullable
        String messenger_background;
        @Nullable
        String messenger4_background;
        @Nullable
        String locale;
        @Nullable
        String help_center_locale;
        @Nullable
        String launcher_logo_url;
        @Nullable
        String messenger_logo_url;
        @Nullable
        String team_intro;
        @Nullable
        String team_greeting;
        @Nullable
        Boolean is_first_request;
        @Nullable
        Boolean inbound_messages;
        @Nullable
        Boolean user_conversation_attachments_enabled;
        @Nullable
        Boolean user_conversation_gifs_enabled;
        @Nullable
        String temporary_expectations_message;
        @Nullable
        Boolean show_powered_by;
        @Nullable
        Boolean audio_enabled;
        @Nullable
        Boolean metrics_enabled;
        @Nullable
        Boolean background_requests_enabled;
        @Nullable
        Boolean primary_color_render_dark_text;
        @Nullable
        Boolean secondary_color_render_dark_text;
        @Nullable
        Boolean help_center_color_render_dark_text;
        @Nullable
        Long local_rate_limit_period;
        @Nullable
        Integer local_rate_limit;
        @Nullable
        Long user_update_dup_cache_max_age;
        @Nullable
        Long soft_reset_timeout;
        @Nullable
        Long new_session_threshold;
        @Nullable
        Long upload_size_limit;
        @Nullable
        NexusConfig.Builder real_time_config;
        @Nullable
        String help_center_url;
        @Nullable
        Set<String> help_center_urls;
        @Nullable
        String help_center_base_color;
        @Nullable
        Set<String> features;
        @Nullable
        Boolean identity_verification_enabled;
        @Nullable
        Boolean access_to_teammate_enabled;
        @Nullable
        Boolean help_center_require_search;
        @Nullable
        Boolean prevent_multiple_inbound_conversations_enabled;
        @Nullable
        Boolean has_open_conversations;
        @Nullable
        ConfigModules modules;
        @Nullable
        Set<String> file_upload_extension_trusted_list;
        @Nullable
        Boolean new_conversation_screen_disabled;

        public Config build() {
            long rateLimitPeriodMs = this.local_rate_limit_period == null ? DEFAULT_RATE_LIMIT_PERIOD_MS : TimeUnit.SECONDS.toMillis(this.local_rate_limit_period);
            int rateLimitCount = this.local_rate_limit == null ? 100 : this.local_rate_limit;
            long userUpdateCacheMaxAgeMs = this.user_update_dup_cache_max_age == null ? DEFAULT_CACHE_MAX_AGE_MS : TimeUnit.SECONDS.toMillis(this.user_update_dup_cache_max_age);
            long softResetTimeoutMs = this.soft_reset_timeout == null ? DEFAULT_SOFT_RESET_TIMEOUT_MS : TimeUnit.SECONDS.toMillis(this.soft_reset_timeout);
            long newSessionThresholdMs = this.new_session_threshold == null ? DEFAULT_SESSION_TIMEOUT_MS : TimeUnit.SECONDS.toMillis(this.new_session_threshold);
            long uploadSizeLimit = this.upload_size_limit == null ? 0x2800000L : this.upload_size_limit;
            NexusConfig nexusConfig = this.real_time_config == null ? new NexusConfig() : this.real_time_config.build();
            Set<String> helpCenterUrls = this.help_center_urls == null ? Collections.emptySet() : this.help_center_urls;
            Set<String> features = this.features == null ? Collections.emptySet() : this.features;
            ConfigModules modules = this.modules == null ? ConfigModules.Companion.getDEFAULT() : this.modules;
            Set<String> fileUploadSupportedFileTypes = this.file_upload_extension_trusted_list == null ? Collections.emptySet() : this.file_upload_extension_trusted_list;
            return new AutoValue_Config(NullSafety.valueOrEmpty(this.name), this.base_color, this.secondary_color, NullSafety.valueOrEmpty(this.welcome_message_plain_text), NullSafety.valueOrEmpty(this.messenger_background), NullSafety.valueOrEmpty(this.messenger4_background), NullSafety.valueOrEmpty(this.locale), NullSafety.valueOrEmpty(this.help_center_locale), NullSafety.valueOrEmpty(this.launcher_logo_url), NullSafety.valueOrEmpty(this.messenger_logo_url), NullSafety.valueOrEmpty(this.team_intro), NullSafety.valueOrEmpty(this.team_greeting), NullSafety.valueOrDefault(this.is_first_request, false), NullSafety.valueOrDefault(this.inbound_messages, false), NullSafety.valueOrDefault(this.user_conversation_attachments_enabled, true), NullSafety.valueOrDefault(this.user_conversation_gifs_enabled, true), NullSafety.valueOrEmpty(this.temporary_expectations_message), NullSafety.valueOrDefault(this.show_powered_by, true), NullSafety.valueOrDefault(this.audio_enabled, true), NullSafety.valueOrDefault(this.metrics_enabled, true), NullSafety.valueOrDefault(this.background_requests_enabled, true), NullSafety.valueOrDefault(this.primary_color_render_dark_text, false), NullSafety.valueOrDefault(this.secondary_color_render_dark_text, false), NullSafety.valueOrDefault(this.help_center_color_render_dark_text, false), rateLimitPeriodMs, rateLimitCount, userUpdateCacheMaxAgeMs, softResetTimeoutMs, newSessionThresholdMs, uploadSizeLimit, nexusConfig, NullSafety.valueOrEmpty(this.help_center_url), helpCenterUrls, this.help_center_base_color, features, NullSafety.valueOrDefault(this.identity_verification_enabled, false), NullSafety.valueOrDefault(this.access_to_teammate_enabled, true), NullSafety.valueOrDefault(this.help_center_require_search, false), NullSafety.valueOrDefault(this.prevent_multiple_inbound_conversations_enabled, false), NullSafety.valueOrDefault(this.has_open_conversations, false), modules, fileUploadSupportedFileTypes, NullSafety.valueOrDefault(this.new_conversation_screen_disabled, true));
        }
    }
}

