/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Locale;

public abstract class IntercomBaseActivity
extends AppCompatActivity {
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(this.localizedContext(newBase));
    }

    private Context localizedContext(Context context) {
        AppConfig appConfig2 = Injector.get().getAppConfigProvider().get();
        Configuration localisedConfiguration = new Configuration(context.getResources().getConfiguration());
        Locale newLocale = ContextLocaliser.convertToLocale(appConfig2.getLocale());
        localisedConfiguration.setLocale(newLocale);
        return context.createConfigurationContext(localisedConfiguration);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.get().getActivityFinisher().register((Activity)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        Injector.get().getActivityFinisher().unregister((Activity)this);
    }
}

