/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.CountryAreaCode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberValidator {
    private static final int PRIORITY_NO_CONFLICTING_CODES = 0;
    private static final int PRIORITY_CONFLICTS_WITH_NO_SUB_CODES = 1;
    private static final int PRIORITY_CONFLICTS_WITH_SUB_CODES = 2;
    private static final String NON_NUMBER_PATTERN = "\\D";
    private static final String WHITESPACE_PATTERN = "\\s+";
    private static final String PREFIX_PATTERN = "^(\\+)|(00)";
    private static final String SPECIAL_CHARACTERS = "^(\\()|(\\))|(-)";
    private static final int MIN_LENGTH_WITHOUT_PREFIX = 6;
    private static final int MAX_LENGTH_WITHOUT_PREFIX = 15;
    private static final List<CountryAreaCode> countryAreaCodes = new ArrayList<CountryAreaCode>();

    public static void loadCountryAreaCodes(Context context) {
        if (countryAreaCodes.isEmpty()) {
            List<CountryAreaCode.Builder> countryCodeBuilders = PhoneNumberValidator.parseCodes(context);
            for (CountryAreaCode.Builder countryAreaBuilder : countryCodeBuilders) {
                countryAreaCodes.add(countryAreaBuilder.build());
            }
        }
    }

    @VisibleForTesting
    static List<CountryAreaCode.Builder> parseCodes(Context context) {
        String jsonString = PhoneNumberValidator.loadJsonFromAsset(context);
        CountryAreaCode.Builder[] countryCodes = (CountryAreaCode.Builder[])new Gson().fromJson(jsonString, CountryAreaCode.Builder[].class);
        List<CountryAreaCode.Builder> countryCodeBuilders = new ArrayList<CountryAreaCode.Builder>();
        if (countryCodes != null) {
            countryCodeBuilders = Arrays.asList(countryCodes);
        }
        return countryCodeBuilders;
    }

    private static String loadJsonFromAsset(Context context) {
        String json = "";
        try {
            InputStream is = context.getResources().openRawResource(R.raw.intercom_area_codes);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return json;
    }

    static int validatePhoneNumber(String value2) {
        String numberToValidate = PhoneNumberValidator.normalizeNumber(value2);
        if (!PhoneNumberValidator.containsPrefix(numberToValidate)) {
            return 4;
        }
        numberToValidate = PhoneNumberValidator.stripPrefix(numberToValidate);
        if (Pattern.compile(NON_NUMBER_PATTERN).matcher(numberToValidate).find()) {
            return 3;
        }
        if ((numberToValidate = numberToValidate.replaceAll(NON_NUMBER_PATTERN, "")).length() > 15) {
            return 5;
        }
        CountryAreaCode countryCode = PhoneNumberValidator.getCountryAreaCodeFromNumber(numberToValidate);
        int dialCodeLength = countryCode.getDialCode().length();
        if (countryCode.equals(CountryAreaCode.UNKNOWN)) {
            return 6;
        }
        if (numberToValidate.substring(dialCodeLength).length() < 6) {
            return 7;
        }
        return 0;
    }

    public static String normalizeNumber(String number) {
        return number.replaceAll(WHITESPACE_PATTERN, "").replaceAll(SPECIAL_CHARACTERS, "");
    }

    @VisibleForTesting
    static boolean containsPrefix(String number) {
        Matcher matcher = Pattern.compile(PREFIX_PATTERN).matcher(number);
        if (!matcher.find()) {
            return false;
        }
        return matcher.start() == 0;
    }

    public static String stripPrefix(String number) {
        return number.replaceFirst(PREFIX_PATTERN, "");
    }

    public static CountryAreaCode getCountryAreaCodeFromNumber(String numberToValidate) {
        CountryAreaCode matchedCode = CountryAreaCode.UNKNOWN;
        for (CountryAreaCode countryAreaCode : countryAreaCodes) {
            String dialCode = countryAreaCode.getDialCode();
            if (!numberToValidate.startsWith(dialCode)) continue;
            int priority = countryAreaCode.getPriority();
            if (priority == 0) {
                return countryAreaCode;
            }
            if (priority == 1) {
                matchedCode = countryAreaCode;
                continue;
            }
            if (priority != 2) continue;
            String numberWithoutDialCode = numberToValidate.substring(countryAreaCode.getDialCode().length());
            for (String areaCode : countryAreaCode.getAreaCodes()) {
                if (!numberWithoutDialCode.startsWith(areaCode)) continue;
                return countryAreaCode;
            }
        }
        return matchedCode;
    }

    public static CountryAreaCode getCountryAreaCodeFromLocale(String deviceCode) {
        for (CountryAreaCode countryAreaCode : countryAreaCodes) {
            String countryCode = countryAreaCode.getCode();
            if (!deviceCode.equalsIgnoreCase(countryCode)) continue;
            return countryAreaCode;
        }
        return CountryAreaCode.UNKNOWN;
    }
}

