/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.attribute.AttributeInputListener;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class DateAttributeView
extends BaseAttributeView
implements AttributeInputListener {
    @VisibleForTesting
    TextView attributeLabel = (TextView)this.findViewById(R.id.attribute_input);

    public DateAttributeView(Context context) {
        this(context, null);
    }

    public DateAttributeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getLayoutRes() {
        return R.layout.intercom_view_list_attribute;
    }

    @Override
    public void displayErrorState(String message) {
        this.setError(message);
    }

    @Override
    public void displayEmptyState() {
        this.attributeLabel.setText((CharSequence)"");
        this.attributeLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.intercom_attribute_date, 0);
    }

    public void updateAttributeContent(Attribute attribute) {
        this.setAttribute(attribute);
        this.attributeLabel.setHint(R.string.intercom_choose_the_date);
        if (attribute.hasValue()) {
            long timestampInSeconds = this.convertTimestampToLong(attribute.getValue());
            if (timestampInSeconds > 0L) {
                String formattedDate = TimeFormatter.formatTimeInMillisAsDate(timestampInSeconds * 1000L);
                this.attributeLabel.setText((CharSequence)formattedDate);
            } else {
                this.attributeLabel.setText((CharSequence)attribute.getValue());
            }
            this.attributeLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.intercom_attribute_verified_tick, 0);
        } else {
            this.displayEmptyState();
        }
    }

    public void setOnClickListener(final String partId, final ConversationListener conversationListener) {
        if (this.getAttribute().hasValue()) {
            return;
        }
        this.attributeLabel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Attribute attribute = DateAttributeView.this.getAttribute();
                conversationListener.onDateAttributeClicked(partId, attribute.getIdentifier(), attribute.getType(), DateAttributeView.this);
            }
        });
    }

    private long convertTimestampToLong(String value) {
        long timestampInSeconds = 0L;
        try {
            timestampInSeconds = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return timestampInSeconds;
    }

    @Override
    public void populateSelectedValue(String value) {
        this.attributeLabel.setText((CharSequence)value);
    }
}

