/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeLocation;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeState;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeStateReducer;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomLinkSolution;
import io.intercom.android.sdk.m5.conversation.reducers.ComposerStateReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ConversationPartsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ErrorReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.HeaderReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.BottomBarUiState;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.states.ConversationUiState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.states.SharpCornersShape;
import io.intercom.android.sdk.m5.conversation.utils.PartExtensionsKt;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.BotIntroState;
import io.intercom.android.sdk.ui.ReplySuggestion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001Be\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer;", "", "config", "Lkotlin/Function0;", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "botIntro", "Lio/intercom/android/sdk/state/BotIntroState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "badgeStateReducer", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeStateReducer;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "computeUiState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "computeUiState$intercom_sdk_base_release", "intercom-sdk-base_release"})
public final class ConversationReducer {
    @NotNull
    private final Function0<AppConfig> config;
    @NotNull
    private final Function0<ComposerSuggestions> composerSuggestions;
    @NotNull
    private final Function0<BotIntroState> botIntro;
    @NotNull
    private final Function0<UserIdentity> userIdentity;
    @NotNull
    private final Function0<TeamPresence> teamPresence;
    @NotNull
    private final Function0<IntercomBadgeStateReducer> badgeStateReducer;

    public ConversationReducer(@NotNull Function0<? extends AppConfig> config, @NotNull Function0<? extends ComposerSuggestions> composerSuggestions, @NotNull Function0<BotIntroState> botIntro, @NotNull Function0<? extends UserIdentity> userIdentity, @NotNull Function0<? extends TeamPresence> teamPresence, @NotNull Function0<IntercomBadgeStateReducer> badgeStateReducer) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(composerSuggestions, (String)"composerSuggestions");
        Intrinsics.checkNotNullParameter(botIntro, (String)"botIntro");
        Intrinsics.checkNotNullParameter(userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter(badgeStateReducer, (String)"badgeStateReducer");
        this.config = config;
        this.composerSuggestions = composerSuggestions;
        this.botIntro = botIntro;
        this.userIdentity = userIdentity;
        this.teamPresence = teamPresence;
        this.badgeStateReducer = badgeStateReducer;
    }

    public /* synthetic */ ConversationReducer(Function0 function0, Function0 function02, Function0 function03, Function0 function04, Function0 function05, Function0 function06, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        if ((n & 4) != 0) {
            function03 = 3.INSTANCE;
        }
        if ((n & 8) != 0) {
            function04 = 4.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function05 = 5.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function06 = 6.INSTANCE;
        }
        this((Function0<? extends AppConfig>)function0, (Function0<? extends ComposerSuggestions>)function02, (Function0<BotIntroState>)function03, (Function0<? extends UserIdentity>)function04, (Function0<? extends TeamPresence>)function05, (Function0<IntercomBadgeStateReducer>)function06);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConversationUiState computeUiState$intercom_sdk_base_release(@NotNull ConversationClientState clientState) {
        ConversationUiState conversationUiState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Conversation conversation = clientState.getConversation();
        String conversationId = clientState.getConversationId();
        NetworkResponse<Conversation.Builder> lastNetworkCall = clientState.getLastNetworkCall();
        boolean isLoadingExistingConversation = conversation == null && conversationId != null;
        if (isLoadingExistingConversation && lastNetworkCall != null && !(lastNetworkCall instanceof NetworkResponse.Success)) {
            conversationUiState = ErrorReducerKt.reduceError(lastNetworkCall);
        } else if (isLoadingExistingConversation) {
            conversationUiState = ConversationUiState.Loading.INSTANCE;
        } else {
            Object object;
            Iterable botIntroParts;
            Collection collection;
            List list;
            ConversationHeader headerState2 = HeaderReducerKt.reduceHeader(clientState, (AppConfig)this.config.invoke(), (TeamPresence)this.teamPresence.invoke());
            BottomBarUiState bottomBarUiState = ComposerStateReducerKt.reduceComposerState(clientState, (AppConfig)this.config.invoke(), (ComposerSuggestions)this.composerSuggestions.invoke());
            List $this$computeUiState_u24lambda_u2d6 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            String string2 = ((AppConfig)this.config.invoke()).getTemporaryExpectationsMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config().temporaryExpectationsMessage");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                String string3 = ((AppConfig)this.config.invoke()).getTemporaryExpectationsMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config().temporaryExpectationsMessage");
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.TemporaryExpectationRow(string3));
            }
            boolean botIntroIsEmpty = ((BotIntroState)this.botIntro.invoke()).getBotIntro().getBlocks().isEmpty();
            if (conversationId == null && clientState.getPendingMessages().isEmpty() && botIntroIsEmpty) {
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.TeamPresenceRow(TeamPresenceReducer.INSTANCE.getTeamPresenceState(null, (TeamPresence)this.teamPresence.invoke(), (AppConfig)this.config.invoke())));
            }
            if (conversation == null && !botIntroIsEmpty) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Part part;
                int n;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = ((BotIntroState)this.botIntro.invoke()).getBotIntro().getBlocks();
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    List list2 = (List)item$iv$iv2;
                    collection = destination$iv$iv;
                    n = 0;
                    Part $this$computeUiState_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0 = part = new Part.Builder().withBlocks((List<Block.Builder>)it).withParticipantIsAdmin(true).build();
                    boolean bl2 = false;
                    $this$computeUiState_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0.setParticipant(((BotIntroState)this.botIntro.invoke()).getBotIntro().getBuiltParticipant());
                    collection.add(part);
                }
                botIntroParts = (List)destination$iv$iv;
                $this$map$iv = botIntroParts;
                collection = $this$computeUiState_u24lambda_u2d6;
                boolean $i$f$mapIndexed = false;
                $this$mapTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index2;
                    void part2;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    part = (Part)item$iv$iv;
                    int $this$computeUiState_u24lambda_u2d6_u24lambda_u2d1_u24lambda_u2d0 = n;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)part2.getMessageStyle(), (Object)"quick_reply") && !PartExtensionsKt.hasNextConcatPart(botIntroParts, (int)index2);
                    boolean isGrouped = PartExtensionsKt.hasPreviousConcatPart(botIntroParts, (int)index2);
                    String string4 = ((AppConfig)this.config.invoke()).getName();
                    object = ConversationPartsReducerKt.getSharpCornersShape(botIntroParts, (int)index2, true);
                    Intrinsics.checkNotNullExpressionValue((Object)part2, (String)"part");
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                    collection2.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper((Part)part2, false, null, true, showAvatarIfAvailable, string4, false, isGrouped, (SharpCornersShape)object, null, null, 1536, null)));
                }
                collection.addAll((List)destination$iv$iv);
            }
            $this$computeUiState_u24lambda_u2d6.addAll((Collection)ConversationPartsReducerKt.reduceMessages(clientState, (UserIdentity)this.userIdentity.invoke(), (AppConfig)this.config.invoke()));
            if (conversation == null && clientState.getPendingMessages().isEmpty()) {
                List<Suggestion> list3 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getSuggestions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"composerSuggestions().suggestions");
                if (!((Collection)list3).isEmpty()) {
                    Collection<ReplySuggestion> collection3;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    String string5 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getPrompt();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"composerSuggestions().prompt");
                    List<Suggestion> list4 = ((ComposerSuggestions)this.composerSuggestions.invoke()).getSuggestions();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"composerSuggestions().suggestions");
                    botIntroParts = list4;
                    String string6 = string5;
                    collection = $this$computeUiState_u24lambda_u2d6;
                    boolean $i$f$map = false;
                    void $i$f$mapIndexed = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Object item$iv$iv2;
                        item$iv$iv2 = (Suggestion)item$iv$iv;
                        collection3 = destination$iv$iv;
                        boolean bl4 = false;
                        String string7 = it.getUuid();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it.uuid");
                        String string8 = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"it.text");
                        collection3.add(new ReplySuggestion(string7, string8));
                    }
                    collection3 = (List)destination$iv$iv;
                    List list5 = collection3;
                    String string9 = string6;
                    collection.add(new ContentRow.ComposerSuggestionRow(string9, list5));
                }
            }
            Iterable $this$forEachIndexed$iv = clientState.getPendingMessages().values();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                void $this$mapTo$iv$iv;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PendingMessage item$iv$iv = (PendingMessage)item$iv;
                int index = n;
                boolean bl5 = false;
                Iterable $this$map$iv = clientState.getPendingMessages().values();
                boolean $i$f$map = false;
                Iterable index2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                    void it2;
                    object = (PendingMessage)item$iv$iv3;
                    Collection collection4 = destination$iv$iv;
                    boolean bl6 = false;
                    collection4.add(it2.getPart());
                }
                List parts = (List)destination$iv$iv;
                boolean showAvatarIfAvailable = !Intrinsics.areEqual((Object)it.getPart().getMessageStyle(), (Object)"quick_reply") && !PartExtensionsKt.hasNextConcatPart(parts, index);
                boolean isGrouped = PartExtensionsKt.hasPreviousConcatPart(parts, index);
                Part part = it.getPart();
                boolean bl7 = index == clientState.getPendingMessages().size() - 1;
                int n2 = it.isFailed() || it.getFailedImageUploadData() != null ? R.string.intercom_failed_delivery : R.string.intercom_message_state_sending;
                String string10 = ((AppConfig)this.config.invoke()).getName();
                boolean bl8 = it.isFailed();
                object = it.getFailedImageUploadData();
                SharpCornersShape sharpCornersShape = ConversationPartsReducerKt.getSharpCornersShape(parts, index, false);
                Integer n3 = n2;
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"name");
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.MessageRow(new ContentRow.MessageRow.PartWrapper(part, bl7, n3, false, showAvatarIfAvailable, string10, bl8, isGrouped, sharpCornersShape, (PendingMessage.FailedImageUploadData)object, null, 1024, null)));
            }
            IntercomBadgeState intercomBadgeState = ((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(new IntercomBadgeLocation.Conversation(clientState.isLaunchedProgrammatically()), IntercomLinkSolution.LIVE_CHAT);
            if (intercomBadgeState instanceof IntercomBadgeState.Shown) {
                $this$computeUiState_u24lambda_u2d6.add(new ContentRow.IntercomBadgeRow(((IntercomBadgeState.Shown)intercomBadgeState).getUrl()));
            }
            List list6 = CollectionsKt.build((List)list);
            conversationUiState = new ConversationUiState.Content(headerState2, list6, bottomBarUiState);
        }
        return conversationUiState;
    }

    public ConversationReducer() {
        this(null, null, null, null, null, null, 63, null);
    }
}

