/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import io.intercom.android.sdk.R;

public class AvatarDefaultDrawable
extends Drawable {
    private final RectF roundRect = new RectF();
    private final Drawable companyIcon;
    private final Paint avatarBackground;

    public AvatarDefaultDrawable(Context context, @ColorInt int colour) {
        this.companyIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_default_avatar_icon);
        this.avatarBackground = new Paint();
        this.avatarBackground.setAntiAlias(true);
        this.avatarBackground.setColor(colour);
        this.avatarBackground.setStyle(Paint.Style.FILL);
    }

    public void draw(Canvas canvas) {
        this.roundRect.set(this.getBounds());
        canvas.drawRoundRect(this.roundRect, (float)(canvas.getHeight() / 2), (float)(canvas.getHeight() / 2), this.avatarBackground);
        int left = (canvas.getWidth() - this.companyIcon.getIntrinsicWidth()) / 2;
        int top = (canvas.getHeight() - this.companyIcon.getIntrinsicHeight()) / 2;
        this.companyIcon.setBounds(left, top, left + this.companyIcon.getIntrinsicWidth(), top + this.companyIcon.getIntrinsicHeight());
        this.companyIcon.draw(canvas);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

