/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RuntimeTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final Class<?> baseType;
    private final String typeFieldName;
    private final Map<String, Class<?>> labelToSubtype = new LinkedHashMap();
    private final Map<Class<?>, String> subtypeToLabel = new LinkedHashMap();
    private final Map<String, Class<?>> labelToIgnoreSubtype = new LinkedHashMap();
    private final Map<Class<?>, String> subtypeToIgnoreLabel = new LinkedHashMap();
    private final boolean maintainType;

    private RuntimeTypeAdapterFactory(Class<?> baseType, String typeFieldName, boolean maintainType) {
        if (typeFieldName == null || baseType == null) {
            throw new NullPointerException();
        }
        this.baseType = baseType;
        this.typeFieldName = typeFieldName;
        this.maintainType = maintainType;
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> baseType, String typeFieldName, boolean maintainType) {
        return new RuntimeTypeAdapterFactory<T>(baseType, typeFieldName, maintainType);
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> baseType, String typeFieldName) {
        return new RuntimeTypeAdapterFactory<T>(baseType, typeFieldName, false);
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> baseType) {
        return new RuntimeTypeAdapterFactory<T>(baseType, "type", false);
    }

    public RuntimeTypeAdapterFactory<T> registerSubtype(Class<? extends T> type, String label) {
        if (type == null || label == null) {
            throw new NullPointerException();
        }
        this.labelToSubtype.put(label, type);
        this.subtypeToLabel.put(type, label);
        return this;
    }

    public RuntimeTypeAdapterFactory<T> registerIgnoredSubtype(Class<? extends T> type, String label) {
        if (type == null || label == null) {
            throw new NullPointerException();
        }
        this.labelToIgnoreSubtype.put(label, type);
        this.subtypeToIgnoreLabel.put(type, label);
        return this;
    }

    public RuntimeTypeAdapterFactory<T> registerSubtype(Class<? extends T> type) {
        return this.registerSubtype(type, type.getSimpleName());
    }

    public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
        TypeAdapter delegate;
        if (type.getRawType() != this.baseType) {
            return null;
        }
        final TypeAdapter jsonElementAdapter = gson.getAdapter(JsonElement.class);
        final LinkedHashMap<String, TypeAdapter> labelToDelegate = new LinkedHashMap<String, TypeAdapter>();
        final LinkedHashMap subtypeToDelegate = new LinkedHashMap();
        final LinkedHashMap<String, TypeAdapter> labelToIgnoreDelegate = new LinkedHashMap<String, TypeAdapter>();
        LinkedHashMap subtypeToIgnoreDelegate = new LinkedHashMap();
        for (Map.Entry<String, Class<?>> entry : this.labelToSubtype.entrySet()) {
            delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(entry.getValue()));
            labelToDelegate.put(entry.getKey(), delegate);
            subtypeToDelegate.put(entry.getValue(), delegate);
        }
        for (Map.Entry<String, Class<?>> entry : this.labelToIgnoreSubtype.entrySet()) {
            delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(entry.getValue()));
            labelToIgnoreDelegate.put(entry.getKey(), delegate);
            subtypeToIgnoreDelegate.put(entry.getValue(), delegate);
        }
        return new TypeAdapter<R>(){

            public R read(JsonReader in) throws IOException {
                JsonElement jsonElement = (JsonElement)jsonElementAdapter.read(in);
                JsonElement labelJsonElement = RuntimeTypeAdapterFactory.this.maintainType ? jsonElement.getAsJsonObject().get(RuntimeTypeAdapterFactory.this.typeFieldName) : jsonElement.getAsJsonObject().remove(RuntimeTypeAdapterFactory.this.typeFieldName);
                if (labelJsonElement == null) {
                    throw new JsonParseException("cannot deserialize " + RuntimeTypeAdapterFactory.this.baseType + " because it does not define a field named " + RuntimeTypeAdapterFactory.this.typeFieldName);
                }
                String label = labelJsonElement.getAsString();
                TypeAdapter delegate = (TypeAdapter)labelToDelegate.get(label);
                if (delegate == null) {
                    delegate = (TypeAdapter)labelToIgnoreDelegate.get("UnSupported");
                }
                return delegate.fromJsonTree(jsonElement);
            }

            public void write(JsonWriter out, R value) throws IOException {
                Class<?> srcType = value.getClass();
                String label = (String)RuntimeTypeAdapterFactory.this.subtypeToLabel.get(srcType);
                TypeAdapter delegate = (TypeAdapter)subtypeToDelegate.get(srcType);
                if (delegate == null) {
                    throw new JsonParseException("cannot serialize " + srcType.getName() + "; did you forget to register a subtype?");
                }
                JsonObject jsonObject = delegate.toJsonTree(value).getAsJsonObject();
                if (RuntimeTypeAdapterFactory.this.maintainType) {
                    jsonElementAdapter.write(out, (Object)jsonObject);
                    return;
                }
                JsonObject clone = new JsonObject();
                if (jsonObject.has(RuntimeTypeAdapterFactory.this.typeFieldName)) {
                    throw new JsonParseException("cannot serialize " + srcType.getName() + " because it already defines a field named " + RuntimeTypeAdapterFactory.this.typeFieldName);
                }
                clone.add(RuntimeTypeAdapterFactory.this.typeFieldName, (JsonElement)new JsonPrimitive(label));
                for (Map.Entry e : jsonObject.entrySet()) {
                    clone.add((String)e.getKey(), (JsonElement)e.getValue());
                }
                jsonElementAdapter.write(out, (Object)clone);
            }
        }.nullSafe();
    }
}

