/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.textinput;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.widget.EditText;
import androidx.annotation.StringRes;
import com.intercom.composer.input.Input;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.conversation.composer.ComposerPresenter;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.textinput.MessengerTextInput;
import io.intercom.android.sdk.conversation.composer.textinput.TextInputWatcher;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.MetricsComposerTextWatcher;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class TextInputManager {
    private final EditText composerText;
    private final TextInputWatcher textWatcher;
    private final MetricsComposerTextWatcher metricsTextWatcher;
    private final Store<State> store;
    private final Context context;
    private final ComposerPresenter.Listener listener;
    private final Drawable textIcon;
    private String conversationId;
    private String initialMessage;

    public TextInputManager(Context context, LayoutInflater inflater, UserIdentity userIdentity, NexusClient nexusClient, MetricTracker metricTracker, String conversationId, String initialMessage, InputDrawableManager inputDrawableManager, Store<State> store2, ComposerPresenter.Listener listener2, String closedConversationId) {
        this.context = context;
        this.listener = listener2;
        this.conversationId = conversationId;
        this.initialMessage = initialMessage;
        this.store = store2;
        this.textIcon = inputDrawableManager.createDrawable(context, R.drawable.intercom_input_text);
        this.composerText = (EditText)inflater.inflate(R.layout.intercom_composer_edit_text, null);
        this.textWatcher = new TextInputWatcher(userIdentity.getIntercomId(), nexusClient, store2, new Handler(Looper.getMainLooper()));
        this.metricsTextWatcher = new MetricsComposerTextWatcher(metricTracker, closedConversationId);
        this.metricsTextWatcher.setConversationId(conversationId);
        this.composerText.addTextChangedListener((TextWatcher)this.textWatcher);
        this.composerText.addTextChangedListener((TextWatcher)this.metricsTextWatcher);
    }

    public void setConversationId(String conversationId) {
        this.textWatcher.setConversationId(conversationId);
        this.metricsTextWatcher.setConversationId(conversationId);
    }

    public void setHint(@StringRes int hintRes) {
        this.composerText.setHint(hintRes);
    }

    public void requestFocus() {
        this.composerText.requestFocus();
    }

    public void clearFocus() {
        this.composerText.clearFocus();
    }

    public Input createInput() {
        String hint = TextUtils.isEmpty((CharSequence)this.conversationId) ? this.context.getResources().getString(R.string.intercom_start_conversation) : this.context.getResources().getString(R.string.intercom_reply_to_conversation);
        Integer hintColor = this.context.getResources().getColor(R.color.intercom_accessibility_grey);
        return new MessengerTextInput("text_input", (inputIdentifier, context) -> this.textIcon, hint, hintColor, this.initialMessage, (sourceInput, charSequence) -> {
            this.listener.onSendButtonPressed(charSequence);
            this.store.dispatch(Actions.composerSendButtonPressed());
        }, this.composerText);
    }

    public void updateMaxLines() {
        this.composerText.setMaxLines(this.context.getResources().getInteger(R.integer.intercom_max_composer_lines));
    }

    public void cleanup() {
        this.store.dispatch(Actions.composerCleared(this.conversationId));
        this.composerText.removeTextChangedListener((TextWatcher)this.textWatcher);
        this.composerText.removeTextChangedListener((TextWatcher)this.metricsTextWatcher);
        this.composerText.clearFocus();
        this.metricsTextWatcher.reset();
    }
}

