/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetricTrackerMiddleware
implements Store.Middleware<State> {
    private final Provider<MetricTracker> trackerProvider;
    private final Set<Object> trackedPartIds = new HashSet<Object>();

    public MetricTrackerMiddleware(Provider<MetricTracker> trackerProvider) {
        this.trackerProvider = trackerProvider;
    }

    @Override
    public void dispatch(Store<State> store2, Action<?> action, Store.NextDispatcher next) {
        switch (action.type()) {
            case UNREAD_CONVERSATIONS_SUCCESS: {
                UsersResponse response = (UsersResponse)action.value();
                List<Conversation> conversations = response.getUnreadConversations().getConversations();
                for (Conversation conversation : conversations) {
                    Part part = conversation.getLastPart();
                    if (this.trackedPartIds.contains(part.getId())) continue;
                    this.trackedPartIds.add(part.getId());
                    this.trackReceivedPart(part, conversation.getId());
                }
                break;
            }
        }
        next.dispatch(action);
    }

    private void trackReceivedPart(Part part, String conversationId) {
        boolean hasAttachments = part.hasAttachments();
        boolean isLinkCard = part.isLinkCard();
        String partId = part.getId();
        String style2 = part.getMessageStyle();
        if (Part.DeliveryOption.SUMMARY != part.getDeliveryOption()) {
            this.tracker().receivedMessageFromFullWhenClosed(hasAttachments, isLinkCard, conversationId, partId, style2);
        } else if (part.isInitialMessage()) {
            this.tracker().receivedMessageFromSnippetWhenClosed(hasAttachments, isLinkCard, conversationId, partId, style2);
        } else {
            this.tracker().receivedReplyFromSnippetWhenClosed(hasAttachments, isLinkCard, conversationId, partId);
        }
    }

    private MetricTracker tracker() {
        return this.trackerProvider.get();
    }
}

