/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import java.util.List;

public class InboxFragment
extends Fragment
implements ConversationClickListener,
EndlessScrollListener,
IntercomToolbar.Listener,
Store.Subscriber<InboxState> {
    private static final int FADE_DURATION_MS = 150;
    private IntercomToolbar intercomToolbar;
    private View rootView;
    @VisibleForTesting
    RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    Listener listener = Listener.EMPTY;
    private InboxAdapter adapter;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    @Nullable
    private Store.Subscription subscription;
    private final Twig twig = LumberMill.getLogger();
    private WallpaperLoader wallpaperLoader;

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement InboxFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector2 = Injector.get();
        this.store = injector2.getStore();
        this.appConfigProvider = injector2.getAppConfigProvider();
        FragmentActivity activity = this.getActivity();
        TimeFormatter timeFormatter2 = new TimeFormatter((Context)activity, injector2.getTimeProvider());
        this.adapter = new InboxAdapter(LayoutInflater.from((Context)activity), this, this.store, timeFormatter2, this.appConfigProvider, injector2.getUserIdentity());
        this.layoutManager = new LinearLayoutManager((Context)activity);
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.twig.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progress_bar);
            this.setUpRecyclerView();
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_inbox);
            this.inboxErrorView.setActionButtonTextColor(this.appConfigProvider.get().getPrimaryColor());
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
            this.setUpToolbar();
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
            this.setToolbarTitle();
            this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.inboxView.scheduleLayoutAnimation();
        }
        return this.rootView;
    }

    private void setUpRecyclerView() {
        this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
        this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
        this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration(this.getContext(), 1);
        dividerItemDecoration.setDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.intercom_list_divider));
        this.inboxView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
    }

    private void setUpToolbar() {
        this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.updateToolbarSize();
        this.intercomToolbar.updateToolbarColors(this.appConfigProvider.get());
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setSubtitleVisibility(8);
        this.intercomToolbar.setLeftNavigationItemVisibility(0);
        this.setToolbarTitle();
        View contentView = this.rootView.findViewById(R.id.intercom_inbox_content);
        contentView.setPadding(contentView.getPaddingLeft(), contentView.getPaddingTop() + WindowUtils.getStatusBarHeight(this.getResources()), contentView.getPaddingRight(), contentView.getPaddingBottom());
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), this.appConfigProvider);
        this.intercomToolbar.loadWallpaper(this.wallpaperLoader);
    }

    private boolean isInboundMessageEnabled() {
        return this.appConfigProvider.get().isInboundMessages();
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, this);
    }

    public void onResume() {
        this.store.dispatch(Actions.inboxOpened());
        this.inboxView.setAlpha(1.0f);
        this.setColorScheme();
        super.onResume();
    }

    public void onDestroyView() {
        this.intercomToolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroyView();
    }

    private void setToolbarTitle() {
        this.intercomToolbar.setTitle(this.getString(R.string.intercom_conversations));
        this.animateHeaderIn();
    }

    private void animateHeaderIn() {
        this.intercomToolbar.findViewById(R.id.intercom_toolbar_title).startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.intercom_profile_slide_in));
    }

    private void setColorScheme() {
        AppConfig appConfig = this.appConfigProvider.get();
        int primaryColor = appConfig.getPrimaryColor();
        int secondaryColor = appConfig.getSecondaryColor();
        this.intercomToolbar.setBackgroundColor(secondaryColor);
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = Listener.EMPTY;
    }

    private void fadeOutInbox(Animator.AnimatorListener listener2) {
        this.intercomToolbar.fadeOutTitle(150);
        this.inboxView.animate().alpha(0.0f).setDuration(150L).setListener(listener2).start();
    }

    @Override
    public void onConversationClicked(int position) {
        final Conversation conversation = this.store.state().inboxState().conversations().get(position);
        this.fadeOutInbox((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                InboxFragment.this.listener.onConversationSelected(conversation);
            }
        });
    }

    @Override
    public void onLoadMore() {
        boolean isEmptyOrPreloadedInHomeScreen;
        InboxState inboxState = this.store.state().inboxState();
        List<Conversation> conversations = inboxState.conversations();
        boolean bl = isEmptyOrPreloadedInHomeScreen = conversations.size() <= 3;
        if (inboxState.status() == InboxState.Status.LOADING || isEmptyOrPreloadedInHomeScreen) {
            return;
        }
        long lastPartCreatedAt = conversations.get(conversations.size() - 1).getLastPart().getCreatedAt();
        this.store.dispatch(Actions.fetchInboxBeforeDateRequest(lastPartCreatedAt));
    }

    @Override
    public void setOverScrollColour() {
        ViewUtils.setOverScrollColour(this.inboxView, this.appConfigProvider.get().getPrimaryColor());
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
        this.listener.onBackClicked();
    }

    @Override
    public void onStateChange(InboxState inboxState) {
        this.adapter.setInboxState(inboxState);
        this.adapter.notifyDataSetChanged();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(inboxState.hasMorePages());
        if (!this.isAdded() || this.getView() == null) {
            return;
        }
        switch (inboxState.status()) {
            case INITIAL: {
                this.displayLoadingView();
                break;
            }
            case LOADING: {
                if (inboxState.conversations().isEmpty()) {
                    this.displayLoadingView();
                    break;
                }
                this.displayInbox();
                break;
            }
            case SUCCESS: {
                if (this.layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                    this.layoutManager.scrollToPosition(0);
                }
                if (inboxState.conversations().isEmpty()) {
                    this.displayEmptyView();
                    break;
                }
                this.displayInbox();
                break;
            }
            default: {
                this.displayErrorView();
            }
        }
    }

    private void displayLoadingView() {
        this.inboxErrorView.setVisibility(8);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(0);
    }

    private void displayInbox() {
        this.inboxView.setVisibility(0);
        this.inboxErrorView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void displayEmptyView() {
        this.inboxErrorView.setTitle(R.string.intercom_no_conversations);
        CharSequence subtitle = Phrase.from(this.getContext(), R.string.intercom_empty_conversations).put("name", this.appConfigProvider.get().getName()).format();
        this.inboxErrorView.setSubtitle(subtitle);
        this.inboxErrorView.setActionButtonVisibility(8);
        this.inboxErrorView.setVisibility(0);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void displayErrorView() {
        this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
        this.inboxErrorView.setSubtitle(R.string.intercom_failed_to_load_conversation);
        this.inboxErrorView.setActionButtonText(R.string.intercom_retry);
        this.inboxErrorView.setActionButtonVisibility(0);
        this.inboxErrorView.setVisibility(0);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    public static interface Listener {
        public static final Listener EMPTY = new Listener(){

            @Override
            public void onConversationSelected(Conversation conversation) {
            }

            @Override
            public void onToolbarCloseClicked() {
            }

            @Override
            public void onBackClicked() {
            }
        };

        public void onConversationSelected(Conversation var1);

        public void onToolbarCloseClicked();

        public void onBackClicked();
    }
}

