/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.intercom.composer.ComposerFragment;
import com.intercom.composer.OnInputSelectedListener;
import com.intercom.composer.input.Input;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.conversation.composer.InputDrawableManager;
import io.intercom.android.sdk.conversation.composer.InputProvider;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryInputManager;
import io.intercom.android.sdk.conversation.composer.textinput.TextInputManager;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.ArrayList;
import java.util.List;

public class ComposerPresenter
implements OnInputSelectedListener {
    private static final int SELECT_INPUT_DELAY_MS = 100;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable defaultInputRunnable = new Runnable(){

        @Override
        public void run() {
            ComposerPresenter.this.composerFragment.selectInput("text_input", true);
        }
    };
    private final Store<State> store;
    private final FrameLayout composerLayout;
    private final TextInputManager textInputManager;
    private final GalleryInputManager galleryInputManager;
    private final InputDrawableManager inputDrawableManager;
    private final ComposerFragment composerFragment;
    private final MetricTracker metricTracker;
    private String conversationId;
    @VisibleForTesting
    InputProvider inputProvider;

    public ComposerPresenter(Listener listener, FrameLayout composerLayout, FragmentManager fragmentManager, LayoutInflater inflater, NexusClient nexusClient, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider2, MetricTracker metricTracker, String conversationId, String initialMessage, Store<State> store2, Context context, @ColorInt int primaryColor, String closedConversationId) {
        this.store = store2;
        this.composerLayout = composerLayout;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        int composerThemeColor = appConfigProvider2.get().primaryColorRenderDarkText() ? ContextCompat.getColor((Context)context, (int)R.color.intercom_black) : primaryColor;
        this.inputDrawableManager = new InputDrawableManager(context, composerThemeColor);
        Fragment fragment = fragmentManager.findFragmentByTag(ComposerFragment.class.getName());
        if (fragment instanceof ComposerFragment) {
            this.composerFragment = (ComposerFragment)fragment;
        } else {
            this.composerFragment = ComposerFragment.newInstance(null, (boolean)false, (int)composerThemeColor);
            fragmentManager.beginTransaction().replace(R.id.composer_container, (Fragment)this.composerFragment, ComposerFragment.class.getName()).commit();
        }
        this.composerFragment.setComposerHost(() -> this.inputProvider.getInputs());
        this.composerFragment.setOnInputSelectedListener((OnInputSelectedListener)this);
        this.textInputManager = new TextInputManager(context, inflater, userIdentity, nexusClient, metricTracker, conversationId, initialMessage, this.inputDrawableManager, store2, listener, closedConversationId);
        this.galleryInputManager = new GalleryInputManager(context, this.inputDrawableManager, listener, metricTracker, conversationId);
        boolean canAccessFiles = true;
        if (Build.VERSION.SDK_INT < 23) {
            canAccessFiles = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }
        this.setUpInputs(fragmentManager, canAccessFiles, appConfigProvider2.get());
    }

    private void setUpInputs(FragmentManager fragmentManager, boolean canAccessFiles, AppConfig appConfig) {
        Fragment fragment;
        ArrayList<Input> inputs = new ArrayList<Input>();
        inputs.add(this.textInputManager.createInput());
        if (appConfig.isGifsEnabled()) {
            inputs.add(this.galleryInputManager.createGifInput());
        }
        if (canAccessFiles && appConfig.isAttachmentsEnabled()) {
            inputs.add(this.galleryInputManager.createGalleryInput());
        }
        if ((fragment = fragmentManager.findFragmentByTag(InputProvider.class.getName())) == null) {
            this.inputProvider = new InputProvider();
            this.addInputsToProvider(inputs);
            fragmentManager.beginTransaction().add((Fragment)this.inputProvider, InputProvider.class.getName()).commit();
        } else {
            this.inputProvider = (InputProvider)fragment;
            if (this.inputProvider.getInputs().isEmpty()) {
                this.addInputsToProvider(inputs);
            }
        }
    }

    private void addInputsToProvider(List inputs) {
        this.inputProvider.addInputs(inputs);
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
        this.textInputManager.setConversationId(conversationId);
        this.galleryInputManager.setConversationId(conversationId);
    }

    public void setHint(@StringRes int hintRes) {
        this.textInputManager.setHint(hintRes);
    }

    public void requestFocus() {
        this.textInputManager.requestFocus();
    }

    public void clearFocus() {
        this.textInputManager.clearFocus();
    }

    public void showComposer() {
        this.composerLayout.setVisibility(0);
    }

    public void hideComposer() {
        this.composerLayout.setVisibility(8);
    }

    public void updateMaxLines() {
        this.textInputManager.updateMaxLines();
    }

    public void cleanup() {
        this.textInputManager.cleanup();
    }

    public void onBackPressed() {
        this.composerFragment.onBackPressed();
    }

    public boolean isOpen() {
        return this.composerFragment.isOpen();
    }

    public void returnToDefaultInput() {
        this.handler.postDelayed(this.defaultInputRunnable, 100L);
    }

    public void onInputSelected(Input input) {
        this.store.dispatch(Actions.composerInputChanged());
        this.metricTracker.clickedInput(this.conversationId, input.getUniqueIdentifier());
    }

    public static interface Listener {
        public void onSendButtonPressed(CharSequence var1);

        public void onUploadImageSelected(GalleryImage var1);

        public void onRemoteImageSelected(GalleryImage var1);
    }
}

