/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.survey.ui.models;

import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.survey.ui.models.Answer;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u0082\u0001\u0004\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer;", "", "()V", "getLength", "", "DateTimeAnswer", "MultipleAnswer", "NoAnswer", "SingleAnswer", "Lio/intercom/android/sdk/survey/ui/models/Answer$DateTimeAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$SingleAnswer;", "intercom-sdk-base_release"})
public abstract class Answer {
    private Answer() {
    }

    public abstract int getLength();

    public /* synthetic */ Answer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$DateTimeAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer;", "date", "", "hours", "", "minutes", "(JII)V", "getDate", "()J", "getHours", "()I", "getMinutes", "component1", "component2", "component3", "copy", "equals", "", "other", "", "formatTime", "", "time", "getAnswer", "getDateAsString", "getLength", "getLocalTime", "hashCode", "toString", "intercom-sdk-base_release"})
    @StabilityInferred(parameters=0)
    public static final class DateTimeAnswer
    extends Answer {
        private final long date;
        private final int hours;
        private final int minutes;
        public static final int $stable;

        public DateTimeAnswer(long date, int hours, int minutes) {
            super(null);
            this.date = date;
            this.hours = hours;
            this.minutes = minutes;
        }

        public final long getDate() {
            return this.date;
        }

        public final int getHours() {
            return this.hours;
        }

        public final int getMinutes() {
            return this.minutes;
        }

        @Override
        public int getLength() {
            return ("" + this.date + this.hours + this.minutes).length();
        }

        @NotNull
        public final String getLocalTime() {
            if (this.hours == -1 || this.minutes == -1) {
                return "";
            }
            String string2 = TimeFormatter.formatFromUtcTime(this.hours, this.minutes);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFromUtcTime(hours, minutes)");
            return string2;
        }

        @NotNull
        public final String getDateAsString() {
            String string2;
            if (this.date != -1L) {
                String string3 = TimeFormatter.formatTimeInMillisAsDate(this.date, "YYYY-MM-dd");
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"formatTimeInMillisAsDate(date, \"YYYY-MM-dd\")");
            } else {
                string2 = "";
            }
            return string2;
        }

        @NotNull
        public final String getAnswer() {
            return this.getDateAsString() + 'T' + this.formatTime(this.hours) + ':' + this.formatTime(this.minutes) + ":00Z";
        }

        private final String formatTime(int time) {
            DecimalFormat formatter = new DecimalFormat("00");
            String string2 = formatter.format((Object)RangesKt.coerceAtLeast((int)time, (int)0));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(time.coerceAtLeast(0))");
            return string2;
        }

        public final long component1() {
            return this.date;
        }

        public final int component2() {
            return this.hours;
        }

        public final int component3() {
            return this.minutes;
        }

        @NotNull
        public final DateTimeAnswer copy(long date, int hours, int minutes) {
            return new DateTimeAnswer(date, hours, minutes);
        }

        public static /* synthetic */ DateTimeAnswer copy$default(DateTimeAnswer dateTimeAnswer, long l, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = dateTimeAnswer.date;
            }
            if ((n3 & 2) != 0) {
                n = dateTimeAnswer.hours;
            }
            if ((n3 & 4) != 0) {
                n2 = dateTimeAnswer.minutes;
            }
            return dateTimeAnswer.copy(l, n, n2);
        }

        @NotNull
        public String toString() {
            return "DateTimeAnswer(date=" + this.date + ", hours=" + this.hours + ", minutes=" + this.minutes + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.date);
            result = result * 31 + Integer.hashCode(this.hours);
            result = result * 31 + Integer.hashCode(this.minutes);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DateTimeAnswer)) {
                return false;
            }
            DateTimeAnswer dateTimeAnswer = (DateTimeAnswer)other;
            if (this.date != dateTimeAnswer.date) {
                return false;
            }
            if (this.hours != dateTimeAnswer.hours) {
                return false;
            }
            return this.minutes == dateTimeAnswer.minutes;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$SingleAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer;", "answer", "", "(Ljava/lang/String;)V", "getAnswer", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "getLength", "", "hashCode", "toString", "intercom-sdk-base_release"})
    @StabilityInferred(parameters=0)
    public static final class SingleAnswer
    extends Answer {
        @NotNull
        private final String answer;
        public static final int $stable;

        public SingleAnswer(@NotNull String answer2) {
            Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
            super(null);
            this.answer = answer2;
        }

        @NotNull
        public final String getAnswer() {
            return this.answer;
        }

        @Override
        public int getLength() {
            return this.answer.length();
        }

        @NotNull
        public final String component1() {
            return this.answer;
        }

        @NotNull
        public final SingleAnswer copy(@NotNull String answer2) {
            Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
            return new SingleAnswer(answer2);
        }

        public static /* synthetic */ SingleAnswer copy$default(SingleAnswer singleAnswer, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = singleAnswer.answer;
            }
            return singleAnswer.copy(string2);
        }

        @NotNull
        public String toString() {
            return "SingleAnswer(answer=" + this.answer + ')';
        }

        public int hashCode() {
            return this.answer.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleAnswer)) {
                return false;
            }
            SingleAnswer singleAnswer = (SingleAnswer)other;
            return Intrinsics.areEqual((Object)this.answer, (Object)singleAnswer.answer);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001bB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer;", "answers", "", "", "otherAnswer", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "(Ljava/util/Set;Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;)V", "getAnswers", "()Ljava/util/Set;", "getOtherAnswer", "()Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "component1", "component2", "copy", "copyWithAnswerToggled", "answer", "copyWithOther", "equals", "", "other", "", "", "getLength", "", "hashCode", "toString", "OtherAnswer", "intercom-sdk-base_release"})
    @StabilityInferred(parameters=0)
    public static final class MultipleAnswer
    extends Answer {
        @NotNull
        private final Set<String> answers;
        @NotNull
        private final OtherAnswer otherAnswer;
        public static final int $stable = 8;

        public MultipleAnswer(@NotNull Set<String> answers, @NotNull OtherAnswer otherAnswer) {
            Intrinsics.checkNotNullParameter(answers, (String)"answers");
            Intrinsics.checkNotNullParameter((Object)otherAnswer, (String)"otherAnswer");
            super(null);
            this.answers = answers;
            this.otherAnswer = otherAnswer;
        }

        public /* synthetic */ MultipleAnswer(Set set, OtherAnswer otherAnswer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                otherAnswer = OtherAnswer.NotSelected.INSTANCE;
            }
            this(set, otherAnswer);
        }

        @NotNull
        public final Set<String> getAnswers() {
            return this.answers;
        }

        @NotNull
        public final OtherAnswer getOtherAnswer() {
            return this.otherAnswer;
        }

        @NotNull
        public final Answer copyWithAnswerToggled(@NotNull String answer2) {
            Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
            Set newValue = CollectionsKt.toMutableSet((Iterable)this.answers);
            if (this.answers.contains(answer2)) {
                newValue.remove(answer2);
            } else {
                newValue.add(answer2);
            }
            return newValue.isEmpty() && this.otherAnswer instanceof OtherAnswer.NotSelected ? (Answer)NoAnswer.ResetNoAnswer.INSTANCE : (Answer)MultipleAnswer.copy$default(this, newValue, null, 2, null);
        }

        @NotNull
        public final Answer copyWithOther(@NotNull OtherAnswer otherAnswer) {
            Intrinsics.checkNotNullParameter((Object)otherAnswer, (String)"otherAnswer");
            return this.answers.isEmpty() && otherAnswer instanceof OtherAnswer.NotSelected ? (Answer)NoAnswer.ResetNoAnswer.INSTANCE : (Answer)MultipleAnswer.copy$default(this, null, otherAnswer, 1, null);
        }

        @NotNull
        public final List<String> getAnswers() {
            List list;
            List $this$getAnswers_u24lambda_u2d0 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getAnswers_u24lambda_u2d0.addAll(CollectionsKt.toList((Iterable)this.answers));
            OtherAnswer otherAnswer = this.otherAnswer;
            if (!Intrinsics.areEqual((Object)otherAnswer, (Object)OtherAnswer.NotSelected.INSTANCE)) {
                if (Intrinsics.areEqual((Object)otherAnswer, (Object)OtherAnswer.SelectedNoText.INSTANCE)) {
                    $this$getAnswers_u24lambda_u2d0.add("Other");
                } else if (otherAnswer instanceof OtherAnswer.SelectedWithText) {
                    $this$getAnswers_u24lambda_u2d0.add(((OtherAnswer.SelectedWithText)this.otherAnswer).getText());
                }
            }
            return CollectionsKt.build((List)list);
        }

        @Override
        public int getLength() {
            return CollectionsKt.joinToString$default((Iterable)this.answers, null, null, null, (int)0, null, (Function1)getLength.1.INSTANCE, (int)31, null).length();
        }

        @NotNull
        public final Set<String> component1() {
            return this.answers;
        }

        @NotNull
        public final OtherAnswer component2() {
            return this.otherAnswer;
        }

        @NotNull
        public final MultipleAnswer copy(@NotNull Set<String> answers, @NotNull OtherAnswer otherAnswer) {
            Intrinsics.checkNotNullParameter(answers, (String)"answers");
            Intrinsics.checkNotNullParameter((Object)otherAnswer, (String)"otherAnswer");
            return new MultipleAnswer(answers, otherAnswer);
        }

        public static /* synthetic */ MultipleAnswer copy$default(MultipleAnswer multipleAnswer, Set set, OtherAnswer otherAnswer, int n, Object object) {
            if ((n & 1) != 0) {
                set = multipleAnswer.answers;
            }
            if ((n & 2) != 0) {
                otherAnswer = multipleAnswer.otherAnswer;
            }
            return multipleAnswer.copy(set, otherAnswer);
        }

        @NotNull
        public String toString() {
            return "MultipleAnswer(answers=" + this.answers + ", otherAnswer=" + this.otherAnswer + ')';
        }

        public int hashCode() {
            int result = ((Object)this.answers).hashCode();
            result = result * 31 + this.otherAnswer.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MultipleAnswer)) {
                return false;
            }
            MultipleAnswer multipleAnswer = (MultipleAnswer)other;
            if (!Intrinsics.areEqual(this.answers, multipleAnswer.answers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.otherAnswer, (Object)multipleAnswer.otherAnswer);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "", "()V", "toString", "", "NotSelected", "SelectedNoText", "SelectedWithText", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$NotSelected;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$SelectedNoText;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$SelectedWithText;", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static abstract class OtherAnswer {
            public static final int $stable;

            private OtherAnswer() {
            }

            @NotNull
            public String toString() {
                return "";
            }

            public /* synthetic */ OtherAnswer(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$NotSelected;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "()V", "intercom-sdk-base_release"})
            @StabilityInferred(parameters=0)
            public static final class NotSelected
            extends OtherAnswer {
                @NotNull
                public static final NotSelected INSTANCE = new NotSelected();
                public static final int $stable;

                private NotSelected() {
                    super(null);
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$SelectedNoText;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "()V", "intercom-sdk-base_release"})
            @StabilityInferred(parameters=0)
            public static final class SelectedNoText
            extends OtherAnswer {
                @NotNull
                public static final SelectedNoText INSTANCE = new SelectedNoText();
                public static final int $stable;

                private SelectedNoText() {
                    super(null);
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer$SelectedWithText;", "Lio/intercom/android/sdk/survey/ui/models/Answer$MultipleAnswer$OtherAnswer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intercom-sdk-base_release"})
            @StabilityInferred(parameters=0)
            public static final class SelectedWithText
            extends OtherAnswer {
                @NotNull
                private final String text;
                public static final int $stable;

                public SelectedWithText(@NotNull String text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    super(null);
                    this.text = text;
                }

                @NotNull
                public final String getText() {
                    return this.text;
                }

                @Override
                @NotNull
                public String toString() {
                    return this.text;
                }

                @NotNull
                public final String component1() {
                    return this.text;
                }

                @NotNull
                public final SelectedWithText copy(@NotNull String text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    return new SelectedWithText(text);
                }

                public static /* synthetic */ SelectedWithText copy$default(SelectedWithText selectedWithText, String string2, int n, Object object) {
                    if ((n & 1) != 0) {
                        string2 = selectedWithText.text;
                    }
                    return selectedWithText.copy(string2);
                }

                public int hashCode() {
                    return this.text.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof SelectedWithText)) {
                        return false;
                    }
                    SelectedWithText selectedWithText = (SelectedWithText)other;
                    return Intrinsics.areEqual((Object)this.text, (Object)selectedWithText.text);
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer;", "()V", "getLength", "", "InitialNoAnswer", "ResetNoAnswer", "Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer$InitialNoAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer$ResetNoAnswer;", "intercom-sdk-base_release"})
    @StabilityInferred(parameters=0)
    public static abstract class NoAnswer
    extends Answer {
        public static final int $stable;

        private NoAnswer() {
            super(null);
        }

        @Override
        public int getLength() {
            return 0;
        }

        public /* synthetic */ NoAnswer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer$InitialNoAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class InitialNoAnswer
        extends NoAnswer {
            @NotNull
            public static final InitialNoAnswer INSTANCE = new InitialNoAnswer();
            public static final int $stable;

            private InitialNoAnswer() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer$ResetNoAnswer;", "Lio/intercom/android/sdk/survey/ui/models/Answer$NoAnswer;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class ResetNoAnswer
        extends NoAnswer {
            @NotNull
            public static final ResetNoAnswer INSTANCE = new ResetNoAnswer();
            public static final int $stable;

            private ResetNoAnswer() {
                super(null);
            }
        }
    }
}

