/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.component;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"computeViewState", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$TeamPresenceState;", "articleId", "", "currentState", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "metricPlace", "isFromSearchBrowse", "", "intercom-sdk-base_release"})
public final class TeammateHelpKt {
    @NotNull
    public static final ArticleViewState.TeamPresenceState computeViewState(@NotNull String articleId, @NotNull ArticleViewState.TeamPresenceState currentState, @NotNull AppConfig appConfig, @NotNull TeamPresence teamPresence, @NotNull String metricPlace, boolean isFromSearchBrowse) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
        int messageButtonText = currentState.getMessageButtonText();
        int messageButtonIcon = currentState.getMessageButtonIcon();
        int messageTitle = currentState.getMessageTitleText();
        int avatarComponentVisibility = 0;
        String metricContext = "style_human";
        if (!appConfig.isAccessToTeammateEnabled()) {
            messageButtonText = R.string.intercom_ask_a_question;
            messageButtonIcon = R.drawable.intercom_conversation_card_question;
            messageTitle = R.string.intercom_bot_expectation_text;
            avatarComponentVisibility = 8;
            metricContext = "style_bot";
        }
        List<Participant> list = teamPresence.getActiveAdmins();
        Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
        List<ArticleViewState.AvatarState> avatars = ArticleViewState.Companion.computeAvatarState(list);
        int n = avatarComponentVisibility;
        int n2 = messageTitle;
        int n3 = messageButtonText;
        int n4 = messageButtonIcon;
        String string2 = metricContext;
        int n5 = appConfig.getPrimaryColor();
        return ArticleViewState.TeamPresenceState.copy$default(currentState, articleId, null, n2, n3, n4, n5, n, avatars, metricPlace, string2, isFromSearchBrowse, 2, null);
    }
}

