/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.view.View;
import androidx.constraintlayout.widget.Group;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.databinding.IntercomConversationHistoryCardBinding;
import io.intercom.android.sdk.homescreen.BaseConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.CardState;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.extensions.ViewExtensionsKt;
import io.intercom.android.sdk.views.InboxRowLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lio/intercom/android/sdk/homescreen/ConversationHistoryViewHolder;", "Lio/intercom/android/sdk/homescreen/BaseConversationCardViewHolder;", "itemView", "Landroid/view/View;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/identity/AppConfig;", "homeClickListener", "Lio/intercom/android/sdk/homescreen/HomeClickListener;", "(Landroid/view/View;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/homescreen/HomeClickListener;)V", "getAppConfigProvider", "()Lio/intercom/android/sdk/Provider;", "binding", "Lio/intercom/android/sdk/databinding/IntercomConversationHistoryCardBinding;", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomConversationHistoryCardBinding;", "getHomeClickListener", "()Lio/intercom/android/sdk/homescreen/HomeClickListener;", "getItemView", "()Landroid/view/View;", "bind", "", "conversationHistoryCard", "Lio/intercom/android/sdk/homescreen/CardState$ConversationHistoryCard;", "intercom-sdk-base_release"})
public final class ConversationHistoryViewHolder
extends BaseConversationCardViewHolder {
    @NotNull
    private final View itemView;
    @NotNull
    private final Provider<AppConfig> appConfigProvider;
    @NotNull
    private final HomeClickListener homeClickListener;
    @NotNull
    private final IntercomConversationHistoryCardBinding binding;

    public ConversationHistoryViewHolder(@NotNull View itemView, @NotNull Provider<AppConfig> appConfigProvider2, @NotNull HomeClickListener homeClickListener) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        Intrinsics.checkNotNullParameter(appConfigProvider2, (String)"appConfigProvider");
        Intrinsics.checkNotNullParameter((Object)homeClickListener, (String)"homeClickListener");
        super(itemView, appConfigProvider2, homeClickListener);
        this.itemView = itemView;
        this.appConfigProvider = appConfigProvider2;
        this.homeClickListener = homeClickListener;
        IntercomConversationHistoryCardBinding intercomConversationHistoryCardBinding = IntercomConversationHistoryCardBinding.bind(this.itemView);
        Intrinsics.checkNotNullExpressionValue((Object)intercomConversationHistoryCardBinding, (String)"bind(itemView)");
        this.binding = intercomConversationHistoryCardBinding;
    }

    @NotNull
    public final View getItemView() {
        return this.itemView;
    }

    @NotNull
    public final Provider<AppConfig> getAppConfigProvider() {
        return this.appConfigProvider;
    }

    @NotNull
    public final HomeClickListener getHomeClickListener() {
        return this.homeClickListener;
    }

    @NotNull
    public final IntercomConversationHistoryCardBinding getBinding() {
        return this.binding;
    }

    public final void bind(@NotNull CardState.ConversationHistoryCard conversationHistoryCard) {
        Intrinsics.checkNotNullParameter((Object)conversationHistoryCard, (String)"conversationHistoryCard");
        this.binding.inboxLayout.removeAllViews();
        this.applyCardBorderStyle((View)this.binding.getRoot());
        Iterable $this$forEach$iv = conversationHistoryCard.getRecentConversations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Conversation conversation = (Conversation)element$iv;
            boolean bl = false;
            Context context = this.binding.getRoot().getContext();
            InboxRowLayout rowLayout = new InboxRowLayout(context);
            rowLayout.updateVerticalPadding(R.dimen.intercom_home_inbox_vertical_padding);
            TimeFormatter timeFormatter2 = new TimeFormatter(context, Injector.get().getTimeProvider());
            rowLayout.updateConversation(conversation, Injector.get().getUserIdentity(), this.appConfigProvider.get(), Injector.get().getStore().state().teamPresence(), timeFormatter2);
            rowLayout.setTag(conversation);
            rowLayout.setOnClickListener(arg_0 -> ConversationHistoryViewHolder.bind$lambda-1$lambda-0(this, conversation, arg_0));
            this.binding.inboxLayout.addView((View)rowLayout);
        }
        this.binding.seePrevious.setOnClickListener(arg_0 -> ConversationHistoryViewHolder.bind$lambda-2(this, arg_0));
        if (conversationHistoryCard.getShowAllConversationsVisibility()) {
            Group group = this.binding.seePreviousLayout;
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"binding.seePreviousLayout");
            ViewExtensionsKt.show((View)group);
            ColorUtils.setTextColorPrimaryOrDark(this.binding.seePrevious, this.appConfigProvider.get());
        } else {
            Group group = this.binding.seePreviousLayout;
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"binding.seePreviousLayout");
            ViewExtensionsKt.hide((View)group);
        }
    }

    private static final void bind$lambda-1$lambda-0(ConversationHistoryViewHolder this$0, Conversation $conversation, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conversation, (String)"$conversation");
        this$0.homeClickListener.onConversationClicked($conversation);
    }

    private static final void bind$lambda-2(ConversationHistoryViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.homeClickListener.onSeePreviousClicked();
    }
}

