/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.intercom.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.activities.IntercomVideoActivity;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.VideoFileBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.blocks.views.VideoPreviewView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;

public class VideoFile
implements VideoFileBlock {
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;
    private final MetricTracker metricTracker;

    VideoFile(StyleType style, Provider<AppConfig> appConfigProvider2, MetricTracker metricTracker) {
        this.style = style;
        this.appConfigProvider = appConfigProvider2;
        this.metricTracker = metricTracker;
    }

    @Override
    public View addVideoFile(String text, String videoUrl, String thumbnailUrl, BlockMetadata blockMetadata, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)videoUrl)) {
            return this.textFallback(text, parent);
        }
        VideoPreviewView previewView = new VideoPreviewView(parent.getContext(), this.appConfigProvider, this.style);
        ImageView thumbnailImageView = previewView.getThumbnailImageView();
        previewView.displayThumbnail(thumbnailUrl);
        this.addClickListenerOnThumbnailView(thumbnailImageView, videoUrl);
        return previewView;
    }

    private View textFallback(String text, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, this.appConfigProvider.get());
        textView.setText((CharSequence)HtmlCompat.fromHtml((String)text));
        return textView;
    }

    private void addClickListenerOnThumbnailView(final ImageView thumbnailView, final String videoUrl) {
        if (this.style != StyleType.CHAT_FULL) {
            thumbnailView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    VideoFile.this.metricTracker.startedToPlayVideo();
                    Context context = thumbnailView.getContext();
                    Intent intent = IntercomVideoActivity.buildIntent(context, videoUrl);
                    context.startActivity(intent);
                }
            });
        }
    }
}

