/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.VideoProvider;
import io.intercom.android.sdk.blocks.lib.interfaces.VideoBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.VideoPreviewView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Video
implements VideoBlock {
    private final StyleType style;
    private final Api api;
    private final Provider<AppConfig> appConfigProvider;
    private final Twig twig = LumberMill.getLogger();

    Video(StyleType style, Api api, Provider<AppConfig> appConfigProvider) {
        this.style = style;
        this.api = api;
        this.appConfigProvider = appConfigProvider;
    }

    @Override
    public View addVideo(String text, VideoProvider provider, String id2, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        VideoPreviewView previewView = new VideoPreviewView(context, this.appConfigProvider, this.style);
        this.fetchThumbnail(provider, id2, previewView);
        previewView.setContentDescription("Play video");
        previewView.announceForAccessibility("Play video");
        BlockUtils.setLayoutMarginsAndGravity((View)previewView, 0x800003, blockMetadata.isLastObject());
        return previewView;
    }

    @VisibleForTesting
    void fetchThumbnail(VideoProvider provider, final String id2, final VideoPreviewView previewView) {
        final ImageView videoImageView = previewView.getThumbnailImageView();
        switch (provider) {
            case WISTIA: {
                String oembedUrl = "https://fast.wistia.com/oembed?url=https://home.wistia.com/medias/" + id2;
                this.api.getVideo(oembedUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        previewView.showFailedImage();
                    }

                    public void onResponse(Call call, Response response) {
                        if (response.isSuccessful()) {
                            final String videoUrl = "https://fast.wistia.net/embed/iframe/" + id2;
                            final String thumbnailUrl = Video.this.getThumbnailUrlFromOembedResponse(response);
                            videoImageView.post(new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(previewView, videoUrl, thumbnailUrl);
                                }
                            });
                        } else {
                            previewView.showFailedImage();
                        }
                    }
                });
                break;
            }
            case YOUTUBE: {
                this.createThumbnail(previewView, "https://www.youtube.com/watch?v=" + id2, "https://img.youtube.com/vi/" + id2 + "/default.jpg");
                break;
            }
            case VIMEO: {
                String thumbnailRequestUrl = "https://vimeo.com/api/v2/video/" + id2 + ".json";
                this.api.getVideo(thumbnailRequestUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        previewView.showFailedImage();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) {
                        if (response.isSuccessful() && response.body() != null) {
                            try {
                                JSONArray arr = new JSONArray(response.body().string());
                                JSONObject obj = arr.getJSONObject(0);
                                String thumbnailUrl = obj.getString("thumbnail_large");
                                videoImageView.post(() -> Video.this.createThumbnail(previewView, "https://player.vimeo.com/video/" + id2, thumbnailUrl));
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                Video.this.twig.internal("ErrorObject", "Couldn't read response body: " + e.getMessage());
                            }
                            finally {
                                response.body().close();
                            }
                        }
                    }
                });
                break;
            }
            case LOOM: {
                String oembedUrl = "https://www.useloom.com/v1/oembed?url=https://www.useloom.com/embed/" + id2;
                this.api.getVideo(oembedUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        previewView.showFailedImage();
                    }

                    public void onResponse(Call call, Response response) {
                        if (response.isSuccessful()) {
                            String videoUrl = "https://www.useloom.com/embed/" + id2;
                            String thumbnailUrl = Video.this.getThumbnailUrlFromOembedResponse(response);
                            videoImageView.post(() -> Video.this.createThumbnail(previewView, videoUrl, thumbnailUrl));
                        } else {
                            previewView.showFailedImage();
                        }
                    }
                });
                break;
            }
        }
    }

    void createThumbnail(VideoPreviewView previewView, String videoUrl, String thumbnailUrl) {
        previewView.displayThumbnail(thumbnailUrl);
        this.addClickListenerOnThumbnailView(previewView.getThumbnailImageView(), videoUrl);
    }

    private void addClickListenerOnThumbnailView(final ImageView imageView, final String videoUrl) {
        if (this.style != StyleType.CHAT_FULL) {
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Uri uri = Uri.parse((String)videoUrl);
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    intent.setFlags(0x10000000);
                    IntentUtils.safelyOpenIntent(imageView.getContext(), intent);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getThumbnailUrlFromOembedResponse(Response response) {
        JSONObject video = new JSONObject();
        try {
            video = new JSONObject(response.body().string());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.twig.internal("ErrorObject", "Couldn't read response body: " + e.getMessage());
        }
        finally {
            response.body().close();
        }
        String thumbnailUrl = video.optString("thumbnail_url");
        int end = thumbnailUrl.indexOf("?image_crop_resized");
        if (end > 0) {
            thumbnailUrl = thumbnailUrl.substring(0, end);
        }
        return thumbnailUrl;
    }
}

