/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class FirstMessageMiddleware
implements Store.Middleware<State> {
    private final Twig twig;
    private final Context context;

    public FirstMessageMiddleware(Twig twig, Context context) {
        this.twig = twig;
        this.context = context;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case BASE_RESPONSE_RECEIVED: {
                BaseResponse response = (BaseResponse)action.value();
                if (!response.getConfig().isFirstRequest()) break;
                this.twig.i(this.context.getString(R.string.intercom_android_activated_message), new Object[0]);
                try {
                    this.showFirstMessageToast();
                }
                catch (Exception e) {
                    this.twig.internal("Couldn't show first message toast: " + e.getMessage());
                }
                break;
            }
        }
    }

    private void showFirstMessageToast() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View view = inflater.inflate(R.layout.intercom_onboarding_layout, null);
        Toast toast = new Toast(this.context);
        toast.setGravity(17, 0, 0);
        toast.setDuration(1);
        toast.setView(view);
        toast.show();
    }
}

