/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeDuper {
    private static final String PREFS_CACHED_ATTRIBUTES = "CachedAttributes";
    private static final String PREFS_EARLIEST_UPDATE_AT = "EarliestUpdateAt";
    private static final String EMPTY_JSON = "{}";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private final Map<String, Object> cachedAttributes = new HashMap<String, Object>();
    private final Provider<AppConfig> appConfigProvider;
    private final SharedPreferences prefs;
    private final Gson gson = new Gson();
    private long earliestUpdateAt = 0L;

    public DeDuper(Provider<AppConfig> appConfigProvider, SharedPreferences sharedPreferences) {
        this.appConfigProvider = appConfigProvider;
        this.prefs = sharedPreferences;
    }

    public void update(Map<String, ?> newAttributes) {
        if (this.hasExpiredCache()) {
            this.cachedAttributes.clear();
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        if (this.earliestUpdateAt == 0L) {
            this.setEarliestUpdateAt(TimeProvider.SYSTEM.currentTimeMillis());
        }
        Map<String, Object> cachedCustomAttributes = DeDuper.getCustomAttributes(this.cachedAttributes);
        Map<String, Object> newCustomAttributes = DeDuper.getCustomAttributes(newAttributes);
        this.cachedAttributes.putAll(newAttributes);
        if (cachedCustomAttributes != null && newCustomAttributes != null) {
            this.cachedAttributes.put(CUSTOM_ATTRIBUTES, DeDuper.mergeMaps(cachedCustomAttributes, newCustomAttributes));
        }
        this.persistCachedAttributes();
    }

    public boolean shouldUpdateUser(Map<String, Object> newAttributes) {
        if (newAttributes.isEmpty() || DeDuper.containsOnlyEmptyCustomAttributes(newAttributes)) {
            return false;
        }
        return this.hasNewAttributeValues(newAttributes) || this.isEmpty() || this.hasExpiredCache();
    }

    private static boolean containsOnlyEmptyCustomAttributes(Map<String, Object> newAttributes) {
        return newAttributes.size() == 1 && Collections.EMPTY_MAP.equals(newAttributes.get(CUSTOM_ATTRIBUTES));
    }

    public void reset() {
        this.cachedAttributes.clear();
        this.earliestUpdateAt = 0L;
        this.persistCachedAttributes();
    }

    public void readPersistedCachedAttributes() {
        if (this.prefs.contains(PREFS_CACHED_ATTRIBUTES) && this.prefs.contains(PREFS_EARLIEST_UPDATE_AT)) {
            Map savedAttributes;
            String jsonString = this.prefs.getString(PREFS_CACHED_ATTRIBUTES, EMPTY_JSON);
            try {
                savedAttributes = (Map)this.gson.fromJson(jsonString, Map.class);
            }
            catch (JsonSyntaxException e) {
                return;
            }
            this.cachedAttributes.putAll(savedAttributes);
            this.earliestUpdateAt = this.prefs.getLong(PREFS_EARLIEST_UPDATE_AT, 0L);
        }
    }

    private void persistCachedAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.cachedAttributes);
        this.prefs.edit().putString(PREFS_CACHED_ATTRIBUTES, this.gson.toJson(attributes)).putLong(PREFS_EARLIEST_UPDATE_AT, this.earliestUpdateAt).apply();
    }

    private boolean isEmpty() {
        return this.cachedAttributes.isEmpty();
    }

    private boolean hasExpiredCache() {
        if (this.earliestUpdateAt == 0L) {
            return false;
        }
        long cacheExpiryMillis = this.appConfigProvider.get().getUserUpdateCacheMaxAgeMs();
        return TimeProvider.SYSTEM.currentTimeMillis() - this.earliestUpdateAt > cacheExpiryMillis;
    }

    private boolean hasNewAttributeValues(Map<String, Object> newAttributes) {
        Object newValue;
        Map<String, Object> cachedCustomAttributes = DeDuper.getCustomAttributes(this.cachedAttributes);
        Map<String, Object> newCustomAttributes = DeDuper.getCustomAttributes(newAttributes);
        if (newCustomAttributes != null) {
            if (cachedCustomAttributes == null) {
                return true;
            }
            for (Map.Entry<String, Object> newEntry : newCustomAttributes.entrySet()) {
                newValue = newEntry.getValue();
                if (newValue == null || newValue.equals(cachedCustomAttributes.get(newEntry.getKey()))) continue;
                return true;
            }
        }
        for (Map.Entry<String, Object> newEntry : newAttributes.entrySet()) {
            if (CUSTOM_ATTRIBUTES.equals(newEntry.getKey()) || (newValue = newEntry.getValue()) == null || newValue.equals(this.cachedAttributes.get(newEntry.getKey()))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Map<String, Object> getCustomAttributes(Map<String, ?> map2) {
        Object attributes = map2.get(CUSTOM_ATTRIBUTES);
        return attributes instanceof Map ? (Map)attributes : null;
    }

    private static Map<String, Object> mergeMaps(Map<String, ?> currentMap, Map<String, ?> newMap) {
        HashMap<String, Object> mergedMap = new HashMap<String, Object>(currentMap);
        mergedMap.putAll(newMap);
        return mergedMap;
    }

    @VisibleForTesting
    Map<String, Object> getMap() {
        return this.cachedAttributes;
    }

    @VisibleForTesting
    void setEarliestUpdateAt(long time) {
        this.earliestUpdateAt = time;
    }

    @VisibleForTesting
    long getEarliestUpdateAt() {
        return this.earliestUpdateAt;
    }
}

