/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import coil.request.ImageRequest;
import coil.request.ImageResult;
import coil.transform.CircleCropTransformation;
import coil.transform.Transformation;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.views.AvatarDefaultDrawable;
import io.intercom.android.sdk.views.AvatarInitialsDrawable;
import org.jetbrains.annotations.NotNull;

public class AvatarUtils {
    public static void preloadAvatar(Avatar avatar, final Runnable runnable, Activity activity) {
        if (avatar.getImageUrl().isEmpty()) {
            runnable.run();
        } else {
            ImageRequest imageRequest = new ImageRequest.Builder((Context)activity).data((Object)avatar.getImageUrl()).listener(new ImageRequest.Listener(){

                public void onStart(@NotNull ImageRequest imageRequest) {
                }

                public void onCancel(@NotNull ImageRequest imageRequest) {
                }

                public void onError(@NotNull ImageRequest imageRequest, @NotNull Throwable throwable) {
                    runnable.run();
                }

                public void onSuccess(@NotNull ImageRequest imageRequest, @NotNull ImageResult.Metadata metadata) {
                    runnable.run();
                }
            }).build();
            IntercomCoilKt.loadIntercomImage((Context)activity, imageRequest);
        }
    }

    public static void loadAvatarIntoView(Avatar avatar, ImageView imageView, AppConfig appConfig) {
        AvatarUtils.createAvatar(avatar, imageView, 0, appConfig);
    }

    public static void createAvatar(Avatar avatar, ImageView imageView, int size, AppConfig appConfig) {
        Context context = imageView.getContext();
        ImageRequest avatarImageRequest = AvatarUtils.getAvatarImageRequestBuilder(context, avatar, appConfig).target(imageView).build();
        IntercomCoilKt.loadIntercomImage(context, avatarImageRequest);
    }

    public static ImageRequest.Builder getAvatarImageRequestBuilder(Context context, Avatar avatar, AppConfig appConfig) {
        Drawable backupDrawable = AvatarUtils.getPlaceHolderDrawable(context, avatar, appConfig);
        return new ImageRequest.Builder(context).data((Object)avatar.getImageUrl()).placeholder(backupDrawable).error(backupDrawable).crossfade(true).transformations(new Transformation[]{new CircleCropTransformation()});
    }

    public static Drawable getPlaceHolderDrawable(Context context, Avatar avatar, AppConfig appConfig) {
        return avatar.getInitials().isEmpty() ? AvatarUtils.getDefaultDrawable(context, appConfig) : AvatarUtils.getInitialsDrawable(avatar.getInitials(), appConfig);
    }

    public static AvatarInitialsDrawable getInitialsDrawable(String initials, AppConfig appConfig) {
        return new AvatarInitialsDrawable(initials.toUpperCase(), appConfig.getSecondaryColorDark());
    }

    public static AvatarDefaultDrawable getDefaultDrawable(Context context, AppConfig appConfig) {
        return new AvatarDefaultDrawable(context, appConfig.getSecondaryColorDark());
    }
}

