/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.video;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.widget.MediaController;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomMediaController
extends MediaController {
    private static final int ANIMATE_DURATION = 200;
    private final IntercomToolbar intercomToolbar;
    private Animator.AnimatorListener animateInListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            IntercomMediaController.this.showMediaPlayer();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animator.AnimatorListener animateOutListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            IntercomMediaController.this.hideMediaPlayer();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public IntercomMediaController(Context context, IntercomToolbar intercomToolbar) {
        super(context);
        this.intercomToolbar = intercomToolbar;
    }

    public void show() {
        this.animateToolbarToAlpha(1.0f);
        this.animate().alpha(1.0f).setDuration(200L).setListener(this.animateInListener).start();
    }

    public void hide() {
        this.animateToolbarToAlpha(0.0f);
        this.animate().alpha(0.0f).setDuration(200L).setListener(this.animateOutListener).start();
    }

    private void hideMediaPlayer() {
        if (!((Activity)this.getContext()).isFinishing()) {
            this.intercomToolbar.setVisibility(8);
            super.hide();
        }
    }

    private void showMediaPlayer() {
        if (!((Activity)this.getContext()).isFinishing()) {
            this.intercomToolbar.setVisibility(0);
            super.show(0);
        }
    }

    public void animateToolbarToAlpha(float alpha) {
        this.intercomToolbar.animate().alpha(alpha).setDuration(200L).start();
    }
}

