/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import coil.request.ImageRequest;
import coil.transform.CircleCropTransformation;
import coil.transform.Transformation;
import com.intercom.commons.utilities.DeviceUtils;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.IntercomPushBroadcastReceiver;
import io.intercom.android.sdk.push.PushAvatarUtils;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.utilities.BitmapUtilsKt;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.List;

class SystemNotificationFactory {
    private static final int LARGE_ICON_SIZE_DP = 48;
    private static final String CONVERSATION_URI = "conversation_id=%s";
    private static final String INTERCOM_SDK_PUSH = "intercom_sdk_push";
    private static final Twig twig = LumberMill.getLogger();

    SystemNotificationFactory() {
    }

    Notification createSingleNotification(PushPayload payload, Context context, AppConfig appConfig) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/conversation_id=%s", payload.getConversationId()));
        String channelId = this.getConversationChannelId(payload);
        return this.createBuilder(context, destination, null, null, -1, channelId, appConfig, payload).setContentTitle(this.getTitle(context, payload)).setContentText((CharSequence)payload.getBody()).setPriority(payload.getPriority()).setLargeIcon(this.generateAvatar(payload, context, appConfig)).build();
    }

    Notification createGroupedNotification(List<PushPayload> payloads, Context context, AppConfig appConfig) {
        Uri destination = Uri.parse((String)"intercom_sdk/multiple_notifications");
        CharSequence subtitle = payloads.size() == 1 ? context.getString(R.string.intercom_one_new_message) : Phrase.from(context, R.string.intercom_new_messages).put("n", payloads.size()).format();
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercom_new_notifications));
        for (PushPayload payload : payloads) {
            SpannableString spannable = new SpannableString(this.groupMessageBody(payload));
            spannable.setSpan((Object)new StyleSpan(1), 0, payload.getAuthorName().length(), 33);
            inboxStyle.addLine((CharSequence)spannable);
        }
        String channelId = this.getConversationChannelId(payloads.get(payloads.size() - 1));
        return this.createBuilder(context, destination, null, null, -1, channelId, appConfig, payloads.get(payloads.size() - 1)).setContentTitle((CharSequence)context.getString(R.string.intercom_new_notifications)).setContentText(subtitle).setPriority(payloads.get(payloads.size() - 1).getPriority()).setStyle((NotificationCompat.Style)inboxStyle).build();
    }

    private CharSequence groupMessageBody(PushPayload payload) {
        String message = payload.getMessage();
        if (!TextUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        return payload.getAuthorName() + ": " + payload.getBody();
    }

    private String getConversationChannelId(PushPayload pushPayload) {
        return pushPayload.isFirstPart() ? "intercom_new_chats_channel" : "intercom_chat_replies_channel";
    }

    Notification createPushOnlyNotification(PushPayload payload, Context context, AppConfig appConfig) {
        String conversationId = payload.getPushOnlyConversationId();
        String instanceId = payload.getInstanceId();
        int requestCode = TextUtils.isEmpty((CharSequence)instanceId) ? conversationId.hashCode() : instanceId.hashCode();
        return this.createBuilder(context, Uri.parse((String)payload.getUri()), conversationId, instanceId, requestCode, "intercom_actions_channel", appConfig, payload).setContentTitle(this.getTitle(context, payload)).setContentText((CharSequence)payload.messageOrBody()).setPriority(payload.getPriority()).build();
    }

    @VisibleForTesting
    NotificationCompat.Builder createBuilder(Context context, Uri destination, @Nullable String pushOnlyConversationId, @Nullable String pushOnlyInstanceId, int requestCode, String channelId, AppConfig appConfig, PushPayload payload) {
        ComponentName receiverComponent = new ComponentName(context, IntercomPushBroadcastReceiver.class);
        Intent openIntent = new Intent("io.intercom.android.sdk.INTERCOM_PUSH_OPENED").setComponent(receiverComponent);
        Intent dismissIntent = new Intent("io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED").setComponent(receiverComponent);
        String packageName = context.getPackageName();
        Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (hostAppIntent == null) {
            hostAppIntent = new Intent();
            twig.e("Couldn't get launch Intent for package '" + packageName + "' - tapping on notification will do nothing", new Object[0]);
        } else {
            hostAppIntent.addCategory("android.intent.category.LAUNCHER");
            hostAppIntent.setData(destination);
            hostAppIntent.putExtra("intercom_push_key", INTERCOM_SDK_PUSH);
            if (pushOnlyConversationId != null) {
                hostAppIntent.putExtra("push_only_convo_id", pushOnlyConversationId);
            }
            if (pushOnlyInstanceId != null) {
                hostAppIntent.putExtra("push_only_instance_id", pushOnlyInstanceId);
            }
        }
        openIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        dismissIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        PendingIntent pendingOpenIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)openIntent, (int)flags);
        PendingIntent pendingDismissIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)dismissIntent, (int)flags);
        return this.baseNotificationBuilder(context, channelId, appConfig, pendingOpenIntent, pendingDismissIntent, payload);
    }

    @VisibleForTesting
    NotificationCompat.Builder baseNotificationBuilder(Context context, String channelId, AppConfig appConfig, PendingIntent contentIntent, PendingIntent deleteIntent, PushPayload payload) {
        int vibrateFlag = DeviceUtils.hasPermission((Context)context, (String)"android.permission.VIBRATE") ? 2 : 0;
        int primaryColor = appConfig.getPrimaryColor();
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId).setSmallIcon(R.drawable.intercom_push_icon).setCategory("msg").setAutoCancel(true).setColor(primaryColor).setLights(primaryColor, 500, 2000).setContentIntent(contentIntent).setDeleteIntent(deleteIntent).setDefaults(1 | vibrateFlag);
        if (!payload.getContentImageUrl().isEmpty()) {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(this.generateContentImage(payload, context, appConfig)));
        }
        return builder;
    }

    @SuppressLint(value={"PrivateResource"})
    CharSequence getTitle(Context context, PushPayload payload) {
        String title = payload.getTitle();
        if (!title.isEmpty()) {
            return title;
        }
        String authorName = payload.getAuthorName();
        String appName = payload.getAppName();
        if (!authorName.isEmpty() && !appName.isEmpty()) {
            return Phrase.from(context, R.string.intercom_teammate_from_company).put("name", authorName).put("company", appName).format();
        }
        return authorName.isEmpty() ? appName : authorName;
    }

    private Bitmap generateAvatar(PushPayload payload, Context context, AppConfig appConfig) {
        if (TextUtils.isEmpty((CharSequence)payload.getImageUrl()) && !TextUtils.isEmpty((CharSequence)payload.getAuthorName())) {
            return PushAvatarUtils.getNotificationInitialsBitmap(context, payload.getAuthorName(), appConfig);
        }
        BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), PushAvatarUtils.getNotificationDefaultBitmap(context, appConfig));
        try {
            int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
            ImageRequest imageRequest = new ImageRequest.Builder(context).error((Drawable)defaultDrawable).transformations(new Transformation[]{new CircleCropTransformation()}).data((Object)payload.getImageUrl()).size(iconSize, iconSize).build();
            Drawable drawable2 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
            return BitmapUtilsKt.drawableToBitmap(drawable2, iconSize, iconSize);
        }
        catch (Exception e) {
            twig.d("Failed to retrieve the notification image", new Object[0]);
            return defaultDrawable.getBitmap();
        }
    }

    private Bitmap generateContentImage(PushPayload payload, Context context, AppConfig appConfig) {
        BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), PushAvatarUtils.getNotificationDefaultBitmap(context, appConfig));
        try {
            int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
            ImageRequest imageRequest = new ImageRequest.Builder(context).error((Drawable)defaultDrawable).data((Object)payload.getContentImageUrl()).build();
            Drawable drawable2 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
            return BitmapUtilsKt.drawableToBitmap(drawable2, iconSize, iconSize);
        }
        catch (Exception e) {
            twig.d("Failed to retrieve the notification image", new Object[0]);
            return defaultDrawable.getBitmap();
        }
    }
}

