/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.commons.utilities.ScreenUtils;
import java.util.List;

public class HomeItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int SPACING_DP = 8;
    private final List<Object> cards;
    private final int spacing;

    public HomeItemDecoration(Context context, List<Object> cards) {
        this.cards = cards;
        this.spacing = ScreenUtils.dpToPx((float)8.0f, (Context)context);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        int position = recyclerView.getChildLayoutPosition(view);
        if (position != -1 && position < this.cards.size()) {
            outRect.set(0, this.topSpacingForPartAtPosition(position), 0, this.spacing);
        }
    }

    private int topSpacingForPartAtPosition(int position) {
        return position == 0 ? this.spacing : 0;
    }
}

