/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.intercom.commons.utilities.TimeProvider;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.KotlinXConvertorFactory;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.api.ShutdownInterceptor;
import io.intercom.android.sdk.api.ShutdownState;
import io.intercom.android.sdk.api.TaggingSocketFactory;
import io.intercom.android.sdk.api.UserIdentityInterceptor;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponseAdapterFactory;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.UtilsKt;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiFactory {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME = ".mobile-messenger.intercom.com";
    private static final String ENDPOINT = "/messenger/mobile/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;
    private static final int INTERCOM_TRAFFIC_TAG = 46837266;
    @Nullable
    private static OkHttpClient okHttpClient = null;
    @Nullable
    private static Retrofit legacyRetrofit = null;
    @Nullable
    private static Retrofit kotlinxRetrofit = null;
    @Nullable
    public static MessengerApi messengerApi;

    public static Api create(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, Store<State> store, String hostname, Provider<AppConfig> appConfigProvider, Gson gson, OpsMetricTracker opsMetricTracker) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity, null);
        return ApiFactory.createWithNetworkClient(context, appIdentity, userIdentity, bus, httpClient, store, hostname, appConfigProvider, gson, opsMetricTracker);
    }

    public static HelpCenterApi createHelpCenterApi(Context context, AppIdentity appIdentity, UserIdentity userIdentity, String hostname, Gson gson) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity, null);
        ApiFactory.createRetrofit(hostname, httpClient, gson);
        return (HelpCenterApi)kotlinxRetrofit.create(HelpCenterApi.class);
    }

    public static Api createWithNetworkClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, OkHttpClient client, Store<State> store, String hostname, Provider<AppConfig> appConfigProvider, Gson gson, OpsMetricTracker opsMetricTracker) {
        if (messengerApi == null) {
            messengerApi = ApiFactory.createMessengerApi(client, hostname, gson);
        }
        CallbackHolder callbackHolder = new CallbackHolder(bus, store);
        RateLimiter rateLimiter = new RateLimiter(appConfigProvider.get());
        return new Api(context, appIdentity, userIdentity, bus, client, messengerApi, callbackHolder, rateLimiter, store, appConfigProvider, gson, opsMetricTracker);
    }

    public static OkHttpClient createConfigurableHttpClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity, @Nullable Interceptor monitoringInterceptor) {
        if (okHttpClient == null) {
            File systemCacheDirectory;
            OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).socketFactory((SocketFactory)new TaggingSocketFactory(SocketFactory.getDefault(), 46837266)).addInterceptor((Interceptor)new UserIdentityInterceptor(userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addInterceptor((Interceptor)new ShutdownInterceptor(new ShutdownState(context, appIdentity, TimeProvider.SYSTEM))).addNetworkInterceptor((Interceptor)HeaderInterceptor.create(context, appIdentity));
            if (monitoringInterceptor != null) {
                builder.addNetworkInterceptor(monitoringInterceptor);
            }
            if ((systemCacheDirectory = context.getCacheDir()) != null) {
                File responseCacheDirectory = new File(systemCacheDirectory.getAbsolutePath(), CACHE_NAME);
                builder.cache(new Cache(responseCacheDirectory, 0xA00000L));
            }
            okHttpClient = builder.build();
        }
        return okHttpClient;
    }

    private static MessengerApi createMessengerApi(OkHttpClient apiHttpClient, String hostname, Gson gson) {
        ApiFactory.createRetrofit(hostname, apiHttpClient, gson);
        return (MessengerApi)legacyRetrofit.create(MessengerApi.class);
    }

    private static void createRetrofit(String hostname, OkHttpClient apiHttpClient, Gson gson) {
        if (legacyRetrofit == null) {
            legacyRetrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).client(apiHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        }
        if (kotlinxRetrofit == null) {
            kotlinxRetrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).client(apiHttpClient).addConverterFactory(KotlinXConvertorFactory.INSTANCE.getConvertorFactory()).build();
        }
    }

    public static String getServerUrl(AppIdentity appIdentity, Context context) {
        String customHost = UtilsKt.readHostFromManifest(context);
        String hostName = TextUtils.isEmpty((CharSequence)customHost) ? ApiFactory.getFullHostname(appIdentity.appId()) : ApiFactory.createUniqueIdentifier(appIdentity.appId()) + customHost;
        return ApiFactory.convertHostnameToUrl(hostName);
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String appId) {
        return ApiFactory.createUniqueIdentifier(appId) + PARTIAL_HOSTNAME;
    }

    static String createUniqueIdentifier(String appId) {
        String identifier = ApiFactory.removeInvalidCharacters(appId) + "-android";
        if (identifier.length() > 63) {
            int endIndex = 63;
            if (identifier.charAt(62) == '-') {
                --endIndex;
            }
            identifier = identifier.substring(0, endIndex);
        }
        return identifier;
    }

    public static String removeInvalidCharacters(String appId) {
        return appId.replaceAll("[^A-Za-z0-9\\-$]", "");
    }
}

