/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.squareup.otto.Bus;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.HashSet;
import java.util.Set;

public class AppConfig {
    private static final String APP_NAME = "app_name";
    private static final String APP_INTERCOM_LINK = "app_intercom_link";
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    private static final String APP_ATTACHMENTS_ENABLED = "app_user_conversation_attachments_enabled";
    private static final String APP_GIFS_ENABLED = "app_user_conversation_gifs_enabled";
    private static final String APP_TEMPORARY_EXPECTATIONS_MESSAGE = "app_temporary_expectations_message";
    private static final String APP_TEAM_BIO = "app_team_bio";
    private static final String APP_PRIMARY_COLOR = "app_primary_color";
    private static final String APP_SECONDARY_COLOR = "app_secondary_color";
    private static final String APP_PRIMARY_COLOR_RENDER_DARK_TEXT = "app_primary_color_render_dark_text";
    private static final String APP_SECONDARY_COLOR_RENDER_DARK_TEXT = "app_secondary_color_render_dark_text";
    private static final String APP_HELP_CENTER_COLOR_RENDER_DARK_TEXT = "app_help_center_color_render_dark_text";
    private static final String APP_USER_UPDATE_CACHE_MAX_AGE_MS = "app_user_update_cache_max_age_ms";
    private static final String APP_RATE_LIMIT_PERIOD_MS = "app_rate_limit_period_ms";
    private static final String APP_SOFT_RESET_TIMEOUT_MS = "app_soft_reset_timeout_ms";
    private static final String APP_NEW_SESSION_THRESHOLD_MS = "new_session_threshold_ms";
    private static final String APP_RATE_LIMIT_COUNT = "app_rate_limit_count";
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    private static final String APP_METRICS_ENABLED = "app_metrics_enabled";
    private static final String APP_WALLPAPER = "app_wallpaper";
    private static final String APP_LOCALE = "app_locale";
    private static final String APP_HELP_CENTER_LOCALE = "help_center_locale";
    private static final String APP_RECEIVED_FROM_SERVER = "app_received_from_server";
    private static final String APP_BACKGROUND_REQUESTS_ENABLED = "app_background_requests_enabled";
    private static final String APP_HELP_CENTER_URL = "help_center_url";
    private static final String APP_HELP_CENTER_URLS = "help_center_urls";
    private static final String APP_HELP_CENTER_PRIMARY_COLOR = "app_help_center_primary_color";
    private static final String APP_FEATURES = "features";
    private static final String APP_LAUNCHER_LOGO_URL = "app_launcher_logo_url";
    private static final String APP_MESSENGER_LOGO_URL = "app_messenger_logo_url";
    private static final String APP_TEAM_INTRO = "app_team_intro";
    private static final String APP_TEAM_GREETING = "app_team_greeting";
    private static final String APP_IDENTITY_VERIFICATION_ENABLED = "app_identity_verification_enabled";
    private static final String APP_ACCESS_TEAMMATE_ENABLED = "access_to_teammate_enabled";
    private static final String APP_HELP_CENTER_REQUIRE_SEARCH = "help_center_require_search";
    private final SharedPreferences prefs;
    @ColorInt
    private final int defaultColor;
    private NexusConfig realTimeConfig = new NexusConfig();
    private String teamProfileBio;
    private String wallpaper;
    private String name;
    private String locale;
    private String helpCenterLocale;
    private String launcherLogoUrl;
    private String messengerLogoUrl;
    private String teamIntro;
    private String teamGreeting;
    @ColorInt
    private int primaryColor;
    @ColorInt
    private int primaryColorDark;
    @ColorInt
    private int secondaryColor;
    @ColorInt
    private int secondaryColorDark;
    private boolean primaryColorRenderDarkText;
    private boolean secondaryColorRenderDarkText;
    private boolean helpCenterColorRenderDarkText;
    private int rateLimitCount;
    private long rateLimitPeriodMs;
    private long userUpdateCacheMaxAgeMs;
    private long newSessionThresholdMs;
    private long softResetTimeoutMs;
    private boolean inboundMessages;
    private boolean attachmentsEnabled;
    private boolean gifsEnabled;
    private String temporaryExpectationsMessage;
    private boolean showIntercomLink;
    private boolean metricsEnabled;
    private boolean audioEnabled;
    private boolean receivedFromServer;
    private boolean backgroundRequestsEnabled;
    private String helpCenterUrl;
    private Set<String> helpCenterUrls;
    @ColorInt
    private int helpCenterBaseColor;
    private Set<String> features;
    private boolean identityVerificationEnabled;
    private boolean accessToTeammateEnabled;
    private boolean helpCenterRequireSearch;

    public AppConfig(Context context) {
        this.defaultColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_main_blue);
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.name = this.prefs.getString(APP_NAME, "");
        this.primaryColor = this.prefs.getInt(APP_PRIMARY_COLOR, this.defaultColor);
        this.primaryColorDark = ColorUtils.darkenColor(this.primaryColor);
        this.secondaryColor = this.prefs.getInt(APP_SECONDARY_COLOR, this.primaryColor);
        this.secondaryColorDark = this.darkSecondaryColor();
        this.primaryColorRenderDarkText = this.prefs.getBoolean(APP_PRIMARY_COLOR_RENDER_DARK_TEXT, false);
        this.secondaryColorRenderDarkText = this.prefs.getBoolean(APP_SECONDARY_COLOR_RENDER_DARK_TEXT, false);
        this.helpCenterColorRenderDarkText = this.prefs.getBoolean(APP_HELP_CENTER_COLOR_RENDER_DARK_TEXT, false);
        this.showIntercomLink = this.prefs.getBoolean(APP_INTERCOM_LINK, true);
        this.inboundMessages = this.prefs.getBoolean(APP_INBOUND_MESSAGES, false);
        this.attachmentsEnabled = this.prefs.getBoolean(APP_ATTACHMENTS_ENABLED, true);
        this.gifsEnabled = this.prefs.getBoolean(APP_GIFS_ENABLED, true);
        this.temporaryExpectationsMessage = this.prefs.getString(APP_TEMPORARY_EXPECTATIONS_MESSAGE, "");
        this.rateLimitCount = this.prefs.getInt(APP_RATE_LIMIT_COUNT, 100);
        this.rateLimitPeriodMs = this.prefs.getLong(APP_RATE_LIMIT_PERIOD_MS, Config.DEFAULT_RATE_LIMIT_PERIOD_MS);
        this.userUpdateCacheMaxAgeMs = this.prefs.getLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, Config.DEFAULT_CACHE_MAX_AGE_MS);
        this.newSessionThresholdMs = this.prefs.getLong(APP_NEW_SESSION_THRESHOLD_MS, Config.DEFAULT_SESSION_TIMEOUT_MS);
        this.softResetTimeoutMs = this.prefs.getLong(APP_SOFT_RESET_TIMEOUT_MS, Config.DEFAULT_SOFT_RESET_TIMEOUT_MS);
        this.metricsEnabled = this.prefs.getBoolean(APP_METRICS_ENABLED, true);
        this.audioEnabled = this.prefs.getBoolean(APP_AUDIO_ENABLED, true);
        this.teamProfileBio = this.prefs.getString(APP_TEAM_BIO, "");
        this.wallpaper = this.prefs.getString(APP_WALLPAPER, "");
        this.locale = this.prefs.getString(APP_LOCALE, "");
        this.helpCenterLocale = this.prefs.getString(APP_HELP_CENTER_LOCALE, "");
        this.receivedFromServer = this.prefs.getBoolean(APP_RECEIVED_FROM_SERVER, false);
        this.backgroundRequestsEnabled = this.prefs.getBoolean(APP_BACKGROUND_REQUESTS_ENABLED, true);
        this.helpCenterUrl = this.prefs.getString(APP_HELP_CENTER_URL, "");
        this.helpCenterUrls = this.prefs.getStringSet(APP_HELP_CENTER_URLS, new HashSet());
        this.helpCenterBaseColor = this.prefs.getInt(APP_HELP_CENTER_PRIMARY_COLOR, this.defaultColor);
        this.features = this.prefs.getStringSet(APP_FEATURES, new HashSet());
        this.launcherLogoUrl = this.prefs.getString(APP_LAUNCHER_LOGO_URL, "");
        this.messengerLogoUrl = this.prefs.getString(APP_MESSENGER_LOGO_URL, "");
        this.teamIntro = this.prefs.getString(APP_TEAM_INTRO, "");
        this.teamGreeting = this.prefs.getString(APP_TEAM_GREETING, "");
        this.identityVerificationEnabled = this.prefs.getBoolean(APP_IDENTITY_VERIFICATION_ENABLED, false);
        this.accessToTeammateEnabled = this.prefs.getBoolean(APP_ACCESS_TEAMMATE_ENABLED, true);
        this.helpCenterRequireSearch = this.prefs.getBoolean(APP_HELP_CENTER_REQUIRE_SEARCH, false);
    }

    public void update(Config config, Bus bus) {
        if (config == Config.NULL) {
            return;
        }
        this.realTimeConfig = config.getRealTimeConfig();
        this.receivedFromServer = true;
        if (this.isNewConfig(config)) {
            this.name = config.getName();
            this.teamProfileBio = config.getWelcomeMessage();
            this.wallpaper = this.getWallpaperFromConfig(config);
            this.primaryColor = this.getConfigColor(config.getPrimaryColor());
            this.primaryColorDark = ColorUtils.darkenColor(this.primaryColor);
            this.secondaryColor = this.getConfigColor(config.getSecondaryColor());
            this.primaryColorRenderDarkText = config.isPrimaryColorRenderDarkText();
            this.secondaryColorRenderDarkText = config.isSecondaryColorRenderDarkText();
            this.helpCenterColorRenderDarkText = config.isHelpCenterColorRenderDarkText();
            this.inboundMessages = config.isInboundMessages();
            this.attachmentsEnabled = config.isAttachmentsEnabled();
            this.gifsEnabled = config.isGifsEnabled();
            this.temporaryExpectationsMessage = config.temporaryExpectationsMessage();
            this.secondaryColorDark = this.darkSecondaryColor();
            this.showIntercomLink = config.isShowPoweredBy();
            this.audioEnabled = config.isAudioEnabled();
            this.metricsEnabled = config.isMetricsEnabled();
            this.userUpdateCacheMaxAgeMs = config.getUserUpdateCacheMaxAge();
            this.rateLimitPeriodMs = config.getRateLimitPeriod();
            this.rateLimitCount = config.getRateLimitCount();
            this.newSessionThresholdMs = config.getNewSessionThreshold();
            this.softResetTimeoutMs = config.getSoftResetTimeout();
            this.backgroundRequestsEnabled = config.isBackgroundRequestsEnabled();
            this.locale = config.getLocale();
            this.helpCenterLocale = config.getHelpCenterLocale();
            this.helpCenterUrl = config.getHelpCenterUrl();
            this.helpCenterUrls = config.getHelpCenterUrls();
            this.helpCenterBaseColor = this.getConfigColor(config.getHelpCenterBaseColor());
            this.features = config.getFeatures();
            this.launcherLogoUrl = config.getLauncherLogoUrl();
            this.messengerLogoUrl = config.getMessengerLogoUrl();
            this.teamIntro = config.getTeamIntro();
            this.teamGreeting = config.getTeamGreeting();
            this.identityVerificationEnabled = config.getIdentityVerificationEnabled();
            this.accessToTeammateEnabled = config.accessToTeammateEnabled();
            this.helpCenterRequireSearch = config.helpCenterRequireSearch();
            this.prefs.edit().putString(APP_NAME, this.name).putString(APP_TEAM_BIO, this.teamProfileBio).putString(APP_WALLPAPER, this.wallpaper).putString(APP_LOCALE, this.locale).putString(APP_HELP_CENTER_LOCALE, this.helpCenterLocale).putString(APP_LAUNCHER_LOGO_URL, this.launcherLogoUrl).putString(APP_MESSENGER_LOGO_URL, this.messengerLogoUrl).putString(APP_TEAM_INTRO, this.teamIntro).putString(APP_TEAM_GREETING, this.teamGreeting).putInt(APP_PRIMARY_COLOR, this.primaryColor).putInt(APP_SECONDARY_COLOR, this.secondaryColor).putInt(APP_HELP_CENTER_PRIMARY_COLOR, this.helpCenterBaseColor).putInt(APP_RATE_LIMIT_COUNT, this.rateLimitCount).putLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, this.userUpdateCacheMaxAgeMs).putLong(APP_RATE_LIMIT_PERIOD_MS, this.rateLimitPeriodMs).putLong(APP_NEW_SESSION_THRESHOLD_MS, this.newSessionThresholdMs).putLong(APP_SOFT_RESET_TIMEOUT_MS, this.softResetTimeoutMs).putBoolean(APP_INTERCOM_LINK, this.showIntercomLink).putBoolean(APP_INBOUND_MESSAGES, this.inboundMessages).putBoolean(APP_ATTACHMENTS_ENABLED, this.attachmentsEnabled).putBoolean(APP_GIFS_ENABLED, this.gifsEnabled).putString(APP_TEMPORARY_EXPECTATIONS_MESSAGE, this.temporaryExpectationsMessage).putBoolean(APP_AUDIO_ENABLED, this.audioEnabled).putBoolean(APP_METRICS_ENABLED, this.metricsEnabled).putBoolean(APP_RECEIVED_FROM_SERVER, true).putBoolean(APP_BACKGROUND_REQUESTS_ENABLED, this.backgroundRequestsEnabled).putBoolean(APP_PRIMARY_COLOR_RENDER_DARK_TEXT, this.primaryColorRenderDarkText).putBoolean(APP_SECONDARY_COLOR_RENDER_DARK_TEXT, this.secondaryColorRenderDarkText).putBoolean(APP_HELP_CENTER_COLOR_RENDER_DARK_TEXT, this.helpCenterColorRenderDarkText).putString(APP_HELP_CENTER_URL, this.helpCenterUrl).putStringSet(APP_HELP_CENTER_URLS, this.helpCenterUrls).putStringSet(APP_FEATURES, this.features).putBoolean(APP_ACCESS_TEAMMATE_ENABLED, this.accessToTeammateEnabled).putBoolean(APP_HELP_CENTER_REQUIRE_SEARCH, this.helpCenterRequireSearch).apply();
            bus.post((Object)new ConfigUpdateEvent());
        }
    }

    private int getConfigColor(@Nullable String color2) {
        return color2 == null ? this.defaultColor : ColorUtils.parseColor(color2);
    }

    public String getName() {
        return this.name;
    }

    public String getTeamProfileBio() {
        return this.removeLineSeparator(this.teamProfileBio);
    }

    public String getWallpaper() {
        return this.wallpaper;
    }

    @ColorInt
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @ColorInt
    public int getPrimaryColorDark() {
        return this.primaryColorDark;
    }

    @ColorInt
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @ColorInt
    public int getSecondaryColorDark() {
        return this.secondaryColorDark;
    }

    public boolean primaryColorRenderDarkText() {
        return this.primaryColorRenderDarkText;
    }

    public boolean secondaryColorRenderDarkText() {
        return this.secondaryColorRenderDarkText;
    }

    public boolean helpCenterColorRenderDarkText() {
        return this.helpCenterColorRenderDarkText;
    }

    public boolean shouldShowIntercomLink() {
        return this.showIntercomLink;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public boolean isGifsEnabled() {
        return this.gifsEnabled;
    }

    public String getTemporaryExpectationsMessage() {
        return this.temporaryExpectationsMessage;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public long getUserUpdateCacheMaxAgeMs() {
        return this.userUpdateCacheMaxAgeMs;
    }

    public long getRateLimitPeriodMs() {
        return this.rateLimitPeriodMs;
    }

    public long getNewSessionThresholdMs() {
        return this.newSessionThresholdMs;
    }

    public long getSoftResetTimeoutMs() {
        return this.softResetTimeoutMs;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getHelpCenterLocale() {
        return this.helpCenterLocale;
    }

    public boolean isReceivedFromServer() {
        return this.receivedFromServer;
    }

    public void reset() {
        this.realTimeConfig = new NexusConfig();
        this.teamGreeting = "";
    }

    public boolean backgroundRequestsDisabled() {
        return !this.backgroundRequestsEnabled;
    }

    public String getHelpCenterUrl() {
        return this.helpCenterUrl;
    }

    public Set<String> getHelpCenterUrls() {
        return this.helpCenterUrls;
    }

    @ColorInt
    public int getHelpCenterBaseColor() {
        return this.helpCenterBaseColor;
    }

    public boolean hasFeature(String feature) {
        return this.features.contains(feature);
    }

    public String getLauncherLogoUrl() {
        return this.launcherLogoUrl;
    }

    public String getMessengerLogoUrl() {
        return this.messengerLogoUrl;
    }

    public String getTeamIntro() {
        return this.removeLineSeparator(this.teamIntro);
    }

    public String getTeamGreeting() {
        return this.teamGreeting;
    }

    public boolean isIdentityVerificationEnabled() {
        return this.identityVerificationEnabled;
    }

    public boolean isAccessToTeammateEnabled() {
        return this.accessToTeammateEnabled;
    }

    public boolean isHelpCenterRequireSearchEnabled() {
        return this.helpCenterRequireSearch;
    }

    private boolean isNewConfig(Config config) {
        return !config.getWelcomeMessage().equals(this.teamProfileBio) || !this.getWallpaperFromConfig(config).equals(this.wallpaper) || !config.getName().equals(this.name) || !config.getLocale().equals(this.locale) || !config.getHelpCenterLocale().equals(this.helpCenterLocale) || this.getConfigColor(config.getPrimaryColor()) != this.primaryColor || this.getConfigColor(config.getSecondaryColor()) != this.secondaryColor || config.isPrimaryColorRenderDarkText() != this.primaryColorRenderDarkText || config.isSecondaryColorRenderDarkText() != this.secondaryColorRenderDarkText || config.isHelpCenterColorRenderDarkText() != this.helpCenterColorRenderDarkText || config.getUserUpdateCacheMaxAge() != this.userUpdateCacheMaxAgeMs || config.isMetricsEnabled() != this.metricsEnabled || config.isAudioEnabled() != this.audioEnabled || config.isShowPoweredBy() != this.showIntercomLink || config.isInboundMessages() != this.inboundMessages || config.isAttachmentsEnabled() != this.attachmentsEnabled || config.isGifsEnabled() != this.gifsEnabled || config.getRateLimitCount() != this.rateLimitCount || config.getRateLimitPeriod() != this.rateLimitPeriodMs || config.getNewSessionThreshold() != this.newSessionThresholdMs || config.getSoftResetTimeout() != this.softResetTimeoutMs || config.isBackgroundRequestsEnabled() != this.backgroundRequestsEnabled || !config.getHelpCenterUrl().equals(this.helpCenterUrl) || !config.getHelpCenterUrls().equals(this.helpCenterUrls) || this.getConfigColor(config.getHelpCenterBaseColor()) != this.helpCenterBaseColor || !config.getFeatures().equals(this.features) || !config.getLauncherLogoUrl().equals(this.launcherLogoUrl) || !config.getMessengerLogoUrl().equals(this.messengerLogoUrl) || !config.getTeamIntro().equals(this.teamIntro) || !config.getTeamGreeting().equals(this.teamGreeting) || !config.getTeamGreeting().equals(this.teamGreeting) || config.getIdentityVerificationEnabled() != this.identityVerificationEnabled || config.accessToTeammateEnabled() != this.accessToTeammateEnabled || !config.temporaryExpectationsMessage().equals(this.temporaryExpectationsMessage) || config.helpCenterRequireSearch() != this.helpCenterRequireSearch;
    }

    @ColorInt
    private int darkSecondaryColor() {
        return ColorUtils.darkenColor(this.secondaryColor);
    }

    private String getWallpaperFromConfig(Config config) {
        String messenger4Background = config.getMessenger4Background();
        return TextUtils.isEmpty((CharSequence)messenger4Background) ? config.getMessengerBackground() : messenger4Background;
    }

    private String removeLineSeparator(String originalString) {
        return originalString.replaceAll(System.getProperty("line.separator"), "");
    }
}

