/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.twig.Twig;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.MessengerApiHelper;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.errorreporting.ErrorReport;
import io.intercom.android.sdk.helpcenter.articles.ArticleStatsArguments;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Sheet;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.user.DeviceData;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class Api {
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    private static final String SENT_FROM_BACKGROUND = "sent_from_background";
    private static final String CAROUSEL_VISIBLE = "carousel_visible";
    private static final String INSTANCE_ID = "instance_id";
    private static final String SCREEN_ID = "screen_id";
    private static final String CAROUSEL_CREATED_VIA = "created_via";
    private static final String CAROUSEL_PROGRAMMATIC = "triggered_from_code";
    private static final String CAROUSEL_AUTOMATIC = "shown_automatically";
    private static final Twig TWIG = LumberMill.getLogger();
    final CallbackHolder callbacks;
    private final Context context;
    private final AppIdentity appIdentity;
    private final Provider<AppConfig> appConfigProvider;
    final UserIdentity userIdentity;
    final OkHttpClient httpClient = new OkHttpClient();
    final Bus bus;
    private final MessengerApi messengerApi;
    private final OkHttpClient apiHttpClient;
    private final int defaultOkHttpMaxRequests;
    private final RateLimiter rateLimiter;
    private final Store<State> store;
    private Gson gson;
    private OpsMetricTracker opsMetricTracker;
    private final retrofit2.Callback<Void> emptyCallback = new retrofit2.Callback<Void>(){

        public void onResponse(retrofit2.Call<Void> call, retrofit2.Response<Void> response) {
        }

        public void onFailure(retrofit2.Call<Void> call, Throwable t) {
        }
    };

    public Api(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, OkHttpClient httpClient, MessengerApi messengerApi, CallbackHolder callbacks, RateLimiter rateLimiter, Store<State> store, Provider<AppConfig> appConfigProvider, Gson gson, OpsMetricTracker opsMetricTracker) {
        this.context = context;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.bus = bus;
        this.messengerApi = messengerApi;
        this.callbacks = callbacks;
        this.rateLimiter = rateLimiter;
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.gson = gson;
        this.opsMetricTracker = opsMetricTracker;
        this.apiHttpClient = httpClient;
        this.defaultOkHttpMaxRequests = httpClient.dispatcher().getMaxRequests();
        this.updateMaxRequests();
    }

    public void updateMaxRequests() {
        int maxRequests = this.userIdentity.hasIntercomId() ? this.defaultOkHttpMaxRequests : 1;
        Dispatcher dispatcher = this.apiHttpClient.dispatcher();
        if (dispatcher.getMaxRequests() != maxRequests) {
            dispatcher.setMaxRequests(maxRequests);
        }
    }

    public void setDeviceToken(String deviceToken) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.context);
        deviceData.put(DEVICE_TOKEN, deviceToken);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, deviceData);
        this.addSecureHash(params);
        this.messengerApi.setDeviceToken(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void removeDeviceToken(String token, UserIdentity previousIdentity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, previousIdentity.toMap());
        params.put(DEVICE_TOKEN, token);
        this.addSecureHash(params);
        this.messengerApi.deleteDeviceToken(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void updateUser(UserUpdateRequest userUpdateRequest) {
        boolean shouldLimitUpdate;
        boolean bl = shouldLimitUpdate = !userUpdateRequest.isInternalUpdate();
        if (shouldLimitUpdate) {
            if (this.rateLimiter.isLimited()) {
                this.rateLimiter.logError();
                return;
            }
            if (this.shouldStopBackgroundRequest(userUpdateRequest.isSentFromBackground())) {
                this.logBackgroundDisabledError();
                return;
            }
            this.rateLimiter.recordRequest();
        }
        this.retriableUpdateUser(this.generateUpdateUserParams(userUpdateRequest));
    }

    @VisibleForTesting
    void retriableUpdateUser(Map<String, Object> params) {
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    private void retriableUpdateUser(final Map<String, Object> params, final String fingerprint) {
        this.messengerApi.updateUser(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            public void onSuccess(UpdateUserResponse.Builder builder) {
                if (fingerprint.equals(Api.this.userIdentity.getFingerprint())) {
                    TWIG.i("Successfully registered or updated user", new Object[0]);
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                    UpdateUserResponse response = builder.build();
                    TeamPresence teamPresence = response.getTeamPresence();
                    Api.this.store.dispatch(Actions.teamPresenceUpdated(teamPresence));
                    ComposerSuggestions composerSuggestions = response.getComposerSuggestions();
                    Api.this.store.dispatch(Actions.composerSuggestionsUpdated(composerSuggestions));
                    Api.this.store.dispatch(Actions.carouselUpdated(response.getCarousel()));
                    Api.this.store.dispatch(Actions.botIntroUpdated(response.getBotIntro()));
                    Api.this.opsMetricTracker.trackEvent("finish", "time-to-complete-ping-ms");
                }
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(errorObject, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint);
                }
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        if (this.rateLimiter.isLimited()) {
            this.rateLimiter.logError();
            return;
        }
        boolean appBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
        if (this.shouldStopBackgroundRequest(appBackgrounded)) {
            this.logBackgroundDisabledError();
            return;
        }
        this.rateLimiter.recordRequest();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("event", eventParams);
        params.put(SENT_FROM_BACKGROUND, appBackgrounded);
        params.put(USER, this.userIdentity.toMap());
        params.put(CAROUSEL_VISIBLE, this.isCarouselVisible());
        this.addSecureHash(params);
        this.messengerApi.logEvent(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.logEventCallback());
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.messengerApi.markAsRead(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markConversationAsDismissed(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("conversation_ids", new String[]{conversationId});
        this.addSecureHash(params);
        this.messengerApi.markAsDismissed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void recordInteractions(String conversationId, String[] interactions) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("interactions", interactions);
        this.addSecureHash(params);
        this.messengerApi.recordInteractions(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void getInbox() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getConversations(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getConversations(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.messengerApi.getUnreadConversations(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId, String uuid) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getConversation(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.conversationCallback(uuid));
    }

    public void rateConversation(String conversationId, int ratingIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("rating_index", ratingIndex);
        this.addSecureHash(params);
        this.messengerApi.rateConversation(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("conversation rating"));
    }

    public void addConversationRatingRemark(String conversationId, String remark) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("remark", remark);
        this.addSecureHash(params);
        this.messengerApi.addConversationRatingRemark(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("adding remark to conversation"));
    }

    public void addConversationQuickReply(String conversationId, Part part, String replyOptionUuid, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        String quickReplyPartId = part.getId();
        if (!part.isInitialMessage()) {
            params.put("quick_reply_part_id", quickReplyPartId);
        }
        params.put("reply_option_uuid", replyOptionUuid);
        this.addSecureHash(params);
        this.messengerApi.addConversationQuickReply(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.replyCallback(tempPartPosition, false, tempPartId, conversationId));
    }

    public void triggerInboundCustomBot(Part part, String suggestionUuid, int tempPartPosition, String uuid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("id", suggestionUuid);
        params.put("client_assigned_uuid", uuid);
        this.addSecureHash(params);
        this.messengerApi.triggerInboundConversation(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.triggeredInboundBotCallback(tempPartPosition, part.getId()));
    }

    public void fetchDefaultGifs(retrofit2.Callback<GifResponse> callback) {
        this.messengerApi.getGifs(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(Collections.emptyMap())).enqueue(callback);
    }

    public void fetchGifs(String query, retrofit2.Callback<GifResponse> callback) {
        Map<String, String> options = Collections.singletonMap("query", query);
        this.messengerApi.getGifs(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(options)).enqueue(callback);
    }

    public void satisfyOperatorCondition(String conversationId, String transitionId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("transition_id", transitionId);
        this.addSecureHash(params);
        this.messengerApi.satisfyCondition(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void replyToConversation(String conversationId, List<Block.Builder> blocks, int tempPartPosition, String tempPartId, boolean isUpload) {
        Map<String, Object> params = this.createBaseReplyParams();
        params.put("blocks", blocks);
        this.messengerApi.replyToConversation(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.replyCallback(tempPartPosition, isUpload, tempPartId, conversationId));
    }

    private Map<String, Object> createBaseReplyParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void reactToConversation(String conversationId, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.messengerApi.reactToConversation(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("add reaction to conversation"));
    }

    public void submitForm(String conversationId, String partId, String identifier, Object formValue, String formType) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("conversation_part_id", partId);
        formParams.put("identifier", identifier);
        formParams.put("value", formValue);
        formParams.put("type", formType);
        params.put("form_params", formParams);
        this.messengerApi.submitForm(conversationId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.submitFormCallback(partId, identifier));
    }

    public void startNewConversation(List<Block.Builder> blocks, int position, String tempPartId, List<Suggestion> suggestions, @Nullable String botIntroId, ArticleStatsArguments articleArgs) {
        Map<String, Object> params = this.baseNewConversationParams();
        params.put("blocks", blocks);
        params.put("composer_suggestions", this.gson.toJson(suggestions));
        if (botIntroId != null) {
            params.put("bot_intro", botIntroId);
        }
        if (!articleArgs.getArticleId().isEmpty()) {
            params.put("article_id", articleArgs.getArticleId());
        }
        if (articleArgs.isFromSearchBrowse()) {
            params.put("article_source", "search_browse");
        }
        this.messengerApi.startNewConversation(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    private Map<String, Object> baseNewConversationParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.appId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    public void uploadFile(final GalleryImage data, final int tempPartPosition, final String tempPartId, final UploadingImageCache uploadingImageCache, final UploadProgressListener listener, final Context context) {
        final String originalFileName = data.getFileName();
        final String mimeType = data.getMimeType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", data.getFileSize());
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", data.getImageWidth());
        uploadMap.put("height", data.getImageHeight());
        params.put(UPLOAD, uploadMap);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.messengerApi.uploadFile(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue((retrofit2.Callback)new BaseCallback<Upload.Builder>(){

            @Override
            public void onSuccess(Upload.Builder builder) {
                final Upload uploadResponse = builder.build();
                uploadingImageCache.put(uploadResponse.getPublicUrl(), data);
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), data, context.getContentResolver(), listener)).build();
                Api.this.httpClient.newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post((RequestBody)requestBody).build()).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        TWIG.e("Upload failed: " + e.getMessage(), new Object[0]);
                        Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(Call call, Response response) {
                        TWIG.internal("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Api.this.bus.post((Object)new UploadEvent(uploadResponse, data.getFileSize(), tempPartPosition, tempPartId));
                        } else {
                            TWIG.e("Upload failed: request body " + response.body(), new Object[0]);
                            Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        response.body().close();
                    }
                });
                TWIG.internal("API Success", "Successfully uploaded");
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Upload failed", error);
            }
        });
    }

    public void getLink(String linkId, retrofit2.Callback<LinkResponse.Builder> callback) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getLink(linkId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void reactToLink(String linkId, @Nullable String articleContentId, int reactionIndex, boolean allowAutoResponse) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("article_content_id", articleContentId);
        params.put("reaction_index", reactionIndex);
        params.put("allow_auto_responses", allowAutoResponse);
        this.addSecureHash(params);
        this.messengerApi.reactToLink(linkId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("add reaction to link"));
    }

    public void sendMetrics(List<MetricObject> metrics, List<OpsMetricObject> opsMetrics, retrofit2.Callback<Void> callback) {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put("metrics", metrics);
        params.put("op_metrics", opsMetrics);
        this.messengerApi.sendMetrics(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void sendErrorReport(ErrorReport report) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("error_report", report);
        this.addSecureHash(params);
        this.messengerApi.reportError(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.loggingCallback("report error"));
    }

    public void getVideo(String url, Callback callback) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                TWIG.internal("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(Call call, Response response) {
                TWIG.internal("Tracking Url", "success");
                response.body().close();
            }
        });
    }

    public void fetchSheet(HashMap<String, Object> sheetParams, retrofit2.Callback<Sheet.Builder> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        params.putAll(sheetParams);
        this.messengerApi.getSheet(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void submitSheet(String uri, Map<String, Object> sheetValues, retrofit2.Callback<Void> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        params.put("uri", uri);
        params.put("sheet_values", sheetValues);
        this.messengerApi.submitSheet(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(callback);
    }

    public void markPushAsOpened(String instanceId) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.messengerApi.markPushAsOpened(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselAsDismissed(String instanceId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselAsDismissed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselAsCompleted(String instanceId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselAsCompleted(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselScreenViewed(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselScreenViewed(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markPermissionGranted(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markPermissionGranted(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void markCarouselActionButtonTapped(String instanceId, String screenId, boolean isProgrammatic) {
        Map<String, Object> params = this.statsSystemParams(instanceId, screenId);
        this.addCarouselCreatedViaParam(params, isProgrammatic);
        this.messengerApi.markCarouselActionButtonTapped(MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.emptyCallback);
    }

    public void fetchCarousel(String carouselId) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.messengerApi.getCarousel(carouselId, MessengerApiHelper.INSTANCE.optionsMapToRequestBody(params)).enqueue(this.callbacks.getCarouselCallback(carouselId));
    }

    protected static boolean isUserNotFound(ErrorObject error, Map userParams) {
        if (error.hasErrorBody() && error.getStatusCode() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1) {
            try {
                JSONObject errorObject = new JSONObject(error.getErrorBody());
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                TWIG.internal("Could not parse error response");
            }
        }
        return false;
    }

    public void addSecureHash(Map<String, Object> params) {
        String hmac = this.userIdentity.getHmac();
        if (!TextUtils.isEmpty((CharSequence)hmac)) {
            params.put(HMAC, hmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(UserUpdateRequest userUpdateRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, DeviceData.generateDeviceData(this.context));
        params.put(NEW_SESSION, userUpdateRequest.isNewSession());
        params.put(SENT_FROM_BACKGROUND, userUpdateRequest.isSentFromBackground());
        params.put(USER_ATTRIBUTES, userUpdateRequest.getAttributes());
        params.put(CAROUSEL_VISIBLE, this.isCarouselVisible());
        this.addSecureHash(params);
        return params;
    }

    private void addCarouselCreatedViaParam(Map<String, Object> params, boolean isProgrammatic) {
        params.put(CAROUSEL_CREATED_VIA, isProgrammatic ? CAROUSEL_PROGRAMMATIC : CAROUSEL_AUTOMATIC);
    }

    private boolean isCarouselVisible() {
        Carousel carousel = this.store.select(Selectors.OVERLAY).carousel();
        return !Carousel.NULL.equals(carousel);
    }

    private Map<String, Object> statsSystemParams(String instanceId, String screenId) {
        Map<String, Object> params = this.statsSystemParams(instanceId);
        params.put(SCREEN_ID, screenId);
        return params;
    }

    private Map<String, Object> statsSystemParams(String instanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(INSTANCE_ID, instanceId);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        return params;
    }

    private boolean shouldStopBackgroundRequest(boolean background) {
        return background && this.appConfigProvider.get().backgroundRequestsDisabled();
    }

    private void logBackgroundDisabledError() {
        TWIG.e("Your request was not sent because the app is in the background. Please contact Intercom to enable background requests.", new Object[0]);
    }

    @VisibleForTesting
    boolean isSynchronous() {
        return this.apiHttpClient.dispatcher().getMaxRequests() == 1;
    }

    @VisibleForTesting
    public void setIdleCallback(Runnable idleCallback) {
        this.apiHttpClient.dispatcher().setIdleCallback(idleCallback);
    }

    @VisibleForTesting
    public boolean isIdle() {
        return this.apiHttpClient.dispatcher().runningCallsCount() == 0;
    }
}

