/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import androidx.annotation.Nullable;
import com.intercom.composer.ComposerFragment;
import com.intercom.input.gallery.GalleryInput;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.helpcenter.collections.IntercomHelpCenterActivity;

public class ActivityUtils {
    private static final String PACKAGE_NAME = Intercom.class.getPackage().getName();
    private static final String COMPOSER_PACKAGE_NAME = ComposerFragment.class.getPackage().getName();
    private static final String COMPOSER_INPUT_PACKAGE_NAME = GalleryInput.class.getPackage().getName();
    private static final String[] INTERCOM_PACKAGES = new String[]{PACKAGE_NAME, COMPOSER_PACKAGE_NAME, COMPOSER_INPUT_PACKAGE_NAME};

    public static boolean isHostActivity(@Nullable Activity activity) {
        return activity != null && ActivityUtils.isInHostAppPackage(activity.getClass().getName());
    }

    public static boolean isFullScreenHelpCenter(@Nullable Activity activity) {
        if (activity == null || activity.getIntent() == null) {
            return false;
        }
        return activity instanceof IntercomHelpCenterActivity;
    }

    private static boolean isInHostAppPackage(String activityName) {
        for (String packageName : INTERCOM_PACKAGES) {
            if (!activityName.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }
}

